/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkg.tools;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativeplatform.pkg.model.Package;
import org.tizen.nativeplatform.pkg.model.PkgStatus;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.types.PkgInstallTypes;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ZypperXmlParser {
    public final String TAG_MESSAGE = "message";
    public final String TAG_STREAM = "stream";
    public final String TAG_SOLVABLE = "solvable";
    public final String ATTR_TYPE = "type";
    public final String ATTR_TYPE_ERROR = "error";
    public final String ATTR_TYPE_INFO = "info";
    public final String ATTR_TYPE_WARN = "warning";
    public final String ATTR_STATUS = "status";
    public final String ATTR_STATUS_INSTALLED = "installed";
    public final String ATTR_STATUS_NOT_INSTALLED = "not-installed";
    public final String RESULT_ERROR_PREFIX = "[ERROR]";
    public final String RESULT_INFO_PREFIX = "[INFO]";
    public final String RESULT_WARN_PREFIX = "[WARN]";
    public final String XML_PREFIX = "<?xml";
    public final String NEW_LINE = "\n";
    private Document doc = null;
    private final Logger logger = LoggerFactory.getLogger(ZypperXmlParser.class);

    public ZypperXmlParser() {
    }

    public ZypperXmlParser(Document doc) {
        this.setDoc(doc);
    }

    public void setDoc(Document doc) {
        this.doc = doc;
    }

    public boolean setDoc(String xml) {
        if (xml.contains("<?xml")) {
            int index = xml.indexOf("<?xml");
            xml = xml.substring(index);
        }
        Document doc = null;
        StringReader sr = new StringReader(xml);
        InputSource is = new InputSource(sr);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(is);
        }
        catch (ParserConfigurationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (SAXException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        if (doc != null) {
            this.doc = doc;
            return true;
        }
        return false;
    }

    public String getErrorMessages() {
        return this.getMessages("type", "error");
    }

    public String getInfoMessages() {
        return this.getMessages("type", "info");
    }

    public String getWarnMessages() {
        return this.getMessages("type", "warning");
    }

    public String getErrorInfoMessages() {
        return this.getMessages("type", "error", "info");
    }

    public String getAllMessages() {
        return this.getMessages("type", "error", "warning", "info");
    }

    public String getErrorWarnMessages() {
        return this.getMessages("type", "error", "warning");
    }

    public String getSolvableMessages() {
        return this.getSolvable("status", "installed", "not-installed");
    }

    public String getPkgListFromStreams() {
        NodeList streamNodes = this.doc.getElementsByTagName("stream");
        String content = "";
        if (streamNodes.getLength() > 0) {
            Node node = streamNodes.item(0).getLastChild();
            if (node == null) {
                return "";
            }
            content = node.getNodeValue();
        }
        return content;
    }

    public Map<String, PkgStatus> getPkgList() {
        String list = this.getPkgListFromStreams();
        HashMap<String, PkgStatus> pkgMap = new HashMap<String, PkgStatus>();
        if (!list.isEmpty()) {
            String[] stringArray = list.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] part = (s = s.replaceAll(" ", "").trim()).split("\\|");
                if (part.length == 5 && !this.isTitleLineInPkgList(part)) {
                    String name = part[2];
                    String version = part[3];
                    String arch = part[4];
                    Package pkg = new Package(name, version, arch);
                    PkgStatus newStatus = new PkgStatus(pkg);
                    newStatus.setNewVer(version);
                    if (pkgMap.get(name) == null) {
                        if (part[0].equals("i")) {
                            newStatus.setInstalledVer(version);
                            newStatus.setInstallInfo(PkgInstallTypes.INSTALLED);
                        }
                        pkgMap.put(name, newStatus);
                    }
                }
                ++n2;
            }
        }
        return pkgMap;
    }

    public List<Repository> getRepoList() {
        ArrayList<Repository> repoList = new ArrayList<Repository>();
        if (this.doc == null) {
            return repoList;
        }
        this.doc.getDocumentElement().normalize();
        NodeList repoNodes = this.doc.getElementsByTagName("repo");
        int i = 0;
        while (i < repoNodes.getLength()) {
            String alias = "";
            String url = "";
            Node repoNode = repoNodes.item(i);
            NamedNodeMap map = repoNode.getAttributes();
            Node node = map.getNamedItem("alias");
            if (node != null) {
                alias = node.getNodeValue();
                NodeList urlNodes = repoNode.getChildNodes();
                int j = 0;
                while (j < urlNodes.getLength()) {
                    Node urlNode = urlNodes.item(j);
                    if (urlNode.getNodeName().equals("url")) {
                        url = urlNode.getTextContent();
                        break;
                    }
                    ++j;
                }
                Repository repo = new Repository(alias, url);
                repoList.add(repo);
            }
            ++i;
        }
        return repoList;
    }

    public Map<String, PkgStatus> getWhatProvideList() {
        String list = this.getPkgListFromStreams();
        HashMap<String, PkgStatus> pkgMap = new HashMap<String, PkgStatus>();
        if (!list.isEmpty()) {
            String[] stringArray = list.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] part = (s = s.replaceAll(" ", "").trim()).split("\\|");
                if (part.length == 6 && !this.isTitleLineInWPList(part)) {
                    String name = part[1];
                    String version = part[3];
                    String arch = part[4];
                    Package pkg = new Package(name, version, arch);
                    PkgStatus newStatus = new PkgStatus(pkg);
                    newStatus.setNewVer(version);
                    if (pkgMap.get(name) == null) {
                        if (part[0].equals("i")) {
                            newStatus.setInstalledVer(version);
                            newStatus.setInstallInfo(PkgInstallTypes.INSTALLED);
                        }
                        pkgMap.put(name, newStatus);
                    }
                }
                ++n2;
            }
        }
        return pkgMap;
    }

    public String getSolvable(String attr, String ... attrValue) {
        if (this.doc == null) {
            return "";
        }
        String result = "";
        this.doc.getDocumentElement().normalize();
        NodeList messageNodes = this.doc.getElementsByTagName("solvable");
        int i = 0;
        while (i < messageNodes.getLength()) {
            Node ii = messageNodes.item(i);
            NamedNodeMap map = ii.getAttributes();
            Node node = map.getNamedItem(attr);
            if (node != null) {
                String type = node.getNodeValue();
                String[] stringArray = attrValue;
                int n = attrValue.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (type.equals(value)) {
                        return value;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return result;
    }

    public String getMessages(String attr, String ... attrValue) {
        if (this.doc == null) {
            return "";
        }
        String result = "";
        this.doc.getDocumentElement().normalize();
        NodeList messageNodes = this.doc.getElementsByTagName("message");
        int i = 0;
        while (i < messageNodes.getLength()) {
            Node ii = messageNodes.item(i);
            NamedNodeMap map = ii.getAttributes();
            Node node = map.getNamedItem(attr);
            if (node != null) {
                String type = node.getNodeValue();
                String[] stringArray = attrValue;
                int n = attrValue.length;
                int n2 = 0;
                while (n2 < n) {
                    String str;
                    Node fChild;
                    String value = stringArray[n2];
                    if (type.equals(value) && (fChild = ii.getFirstChild()) != null && (str = fChild.getNodeValue()) != null && !str.isEmpty()) {
                        result = String.valueOf(result) + "[" + value + "] " + str + (str.endsWith("\n") ? "" : "\n");
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return result;
    }

    private boolean isTitleLineInPkgList(String[] line) {
        return line.length == 5 && line[1].equals("Repository") && line[2].equals("Name");
    }

    private boolean isTitleLineInWPList(String[] line) {
        return line.length == 6 && line[1].equals("Name") && line[2].equals("Type");
    }
}

