/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizard.pages;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.launcher.coredump.CSFileReader;
import org.tizen.nativeplatform.launcher.coredump.CoredumpSelectionHandler;
import org.tizen.nativeplatform.launcher.coredump.model.CSVO;
import org.tizen.nativeplatform.launcher.coredump.model.CoredumpModel;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchCommonPage;
import org.tizen.nativeplatform.launcher.wizards.PlatformCoredumpLaunchWizard;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.util.PlatformFileUtil;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.sdblib.service.FileEntry;

public class PlatformLaunchSettingCorePage
extends PlatformLaunchCommonPage {
    private final String BUNDLE_NAME = String.valueOf(PlatformLaunchSettingCorePage.class.getPackage().getName()) + ".LaunchWizardPageUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private PlatformCoredumpLaunchWizard wizard;
    private PkgCommandTarget target;
    private Group coredumpInfoGroup;
    private Text corefilePath;
    private Text csfilePath;
    private FileEntry remoteCorefile;
    private FileEntry remoteCsfile;
    private Label lPkgName;
    private Label lPkgVer;
    private Label lProcName;
    private Label lDate;
    private Label lExec;
    private Label lModel;
    private Label lBuildNum;
    private Button coreBrowseButton;
    private Button coreLocalBrowseButton;
    private Button csBrowseButton;
    private Button csLocalBrowseButton;
    private CSVO csvo = null;
    private CoredumpModel coredumpModel;
    private String originCoredumpPath = "";
    private String originCsfilePath = "";
    private String errorMessage = "";
    private String binaryPath = "";
    private String coredumpPath = "";
    private String csPath = "";
    private String csFileContent = "";
    private boolean connectedDevice = false;
    private String DEBUG_COREFILE_PATH = "/opt/usr/share/crash";
    private String DEBUG_CSFILE_PATH = "/opt/usr/share/crash";
    protected final Logger logger = LoggerFactory.getLogger(PlatformLaunchSettingCorePage.class);

    public PlatformLaunchSettingCorePage(PlatformCoredumpLaunchWizard wizard, String pageName, Shell shell, IProject project, IConfiguration config, PkgCommandTarget target) {
        super(pageName, shell, project, config, target);
        this.wizard = wizard;
        this.target = target;
        this.setTitle(this.resources.getString("CorePage.Title"));
        this.setDescription(this.resources.getString("CorePage.Desc.SetCorefile"));
        this.setPageComplete(false);
        this.setErrorMessage(null);
        if (target.getDevice() != null) {
            this.connectedDevice = true;
        }
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(768);
        gridData.minimumHeight = 0;
        composite.setLayoutData((Object)gridData);
        this.createCoreFileControl(composite);
        this.createCoredumpInfoControl(composite);
        this.setControl((Control)composite);
    }

    public void createCoreFileControl(Composite parent) {
        Group inputFileGroup = new Group(parent, 0);
        inputFileGroup.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        inputFileGroup.setLayout((Layout)layout);
        inputFileGroup.setText(this.resources.getString("CorePage.Label.InputGroup.Title"));
        this.createInputCoreFileControl((Composite)inputFileGroup);
    }

    public void createCoredumpInfoControl(Composite parent) {
        this.coredumpInfoGroup = new Group(parent, 0);
        this.coredumpInfoGroup.setLayoutData((Object)new GridData(1808));
        this.coredumpInfoGroup.setLayout((Layout)new GridLayout(2, false));
        this.coredumpInfoGroup.setText(this.resources.getString("CorePage.Label.CoredumpInfoGroup.Title"));
        this.createSwInfoControl((Composite)this.coredumpInfoGroup);
        this.createPkgInfoControl((Composite)this.coredumpInfoGroup);
        this.createCrashInfoControl((Composite)this.coredumpInfoGroup);
    }

    public void createSwInfoControl(Composite parent) {
        Label Model = new Label(parent, 0);
        Model.setText(this.resources.getString("CorePage.Label.Model"));
        this.lModel = new Label(parent, 0);
        this.lModel.setText("");
        Label BuildNum = new Label(parent, 0);
        BuildNum.setText(this.resources.getString("CorePage.Label.BuildNum"));
        this.lBuildNum = new Label(parent, 0);
        this.lBuildNum.setText("");
    }

    public void createCrashInfoControl(Composite parent) {
        Label ProcName = new Label(parent, 0);
        ProcName.setText(this.resources.getString("CorePage.Label.Procname"));
        this.lProcName = new Label(parent, 0);
        this.lProcName.setText("");
        Label Date = new Label(parent, 0);
        Date.setText(this.resources.getString("CorePage.Label.Date"));
        this.lDate = new Label(parent, 0);
        this.lDate.setText("");
        Label PkgExec = new Label(parent, 0);
        PkgExec.setText(this.resources.getString("CorePage.Label.Exec"));
        this.lExec = new Label(parent, 0);
        this.lExec.setText("");
    }

    public void createPkgInfoControl(Composite parent) {
        Label PkgName = new Label(parent, 0);
        PkgName.setText(this.resources.getString("CorePage.Label.Pkgname"));
        this.lPkgName = new Label(parent, 0);
        this.lPkgName.setText("");
        Label PkgVer = new Label(parent, 0);
        PkgVer.setText(this.resources.getString("CorePage.Label.Pkgver"));
        this.lPkgVer = new Label(parent, 0);
        this.lPkgVer.setText("");
    }

    private void createInputCoreFileControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label corefileLabel = new Label(composite, 0);
        GridData lGridData = new GridData(768);
        corefileLabel.setText(this.resources.getString("CorePage.Label.Corefile"));
        corefileLabel.setLayoutData((Object)lGridData);
        Composite btComp = new Composite(composite, 0);
        btComp.setLayout((Layout)layout);
        this.coreBrowseButton = new Button(btComp, 8);
        this.coreBrowseButton.setText(this.resources.getString("BinPage.Button.Browse"));
        this.coreBrowseButton.setEnabled(this.connectedDevice);
        this.coreBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PlatformLaunchSettingCorePage.this.remoteCorefile = PlatformLaunchSettingCorePage.this.handleBrowseButtonSelected(PlatformLaunchSettingCorePage.this.resources.getString("CorePage.Corefile.Browse.Title"), PlatformLaunchSettingCorePage.this.DEBUG_COREFILE_PATH);
                if (PlatformLaunchSettingCorePage.this.remoteCorefile != null && PlatformLaunchSettingCorePage.this.remoteCorefile.getDate() != null) {
                    PlatformLaunchSettingCorePage.this.originCoredumpPath = PlatformLaunchSettingCorePage.this.remoteCorefile.getFullPath();
                    PlatformLaunchSettingCorePage.this.processRemoteCorefile(PlatformLaunchSettingCorePage.this.originCoredumpPath);
                    if (PlatformLaunchSettingCorePage.this.coredumpPath != null && !PlatformLaunchSettingCorePage.this.coredumpPath.isEmpty() && PlatformLaunchSettingCorePage.this.coredumpModel != null) {
                        if (PlatformLaunchSettingCorePage.this.target.getCommander(CmdTargetTypes.HOST).is80386File(PlatformLaunchSettingCorePage.this.coredumpPath)) {
                            PlatformLaunchSettingCorePage.this.coredumpModel.setX86coredump(true);
                        } else if (PlatformLaunchSettingCorePage.this.target.getCommander(CmdTargetTypes.HOST).isArmFile(PlatformLaunchSettingCorePage.this.coredumpPath)) {
                            PlatformLaunchSettingCorePage.this.coredumpModel.setArmcoredump(true);
                        }
                    }
                }
            }
        });
        this.coreLocalBrowseButton = new Button(btComp, 8);
        this.coreLocalBrowseButton.setText(this.resources.getString("CorePage.Button.Localbrowse"));
        this.coreLocalBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog fd = new FileDialog(PlatformLaunchSettingCorePage.this.shell, 4100);
                fd.setText(PlatformLaunchSettingCorePage.this.resources.getString("CorePage.Corefile.Browse.Title"));
                String[] filterExt = new String[]{"*.coredump"};
                fd.setFilterExtensions(filterExt);
                String localCorefile = fd.open();
                if (localCorefile != null) {
                    PlatformLaunchSettingCorePage.this.originCoredumpPath = localCorefile;
                    PlatformLaunchSettingCorePage.this.processLocalCorefile(PlatformLaunchSettingCorePage.this.originCoredumpPath);
                    if (PlatformLaunchSettingCorePage.this.coredumpPath != null && !PlatformLaunchSettingCorePage.this.coredumpPath.isEmpty() && PlatformLaunchSettingCorePage.this.coredumpModel != null) {
                        if (PlatformLaunchSettingCorePage.this.target.getCommander(CmdTargetTypes.HOST).is80386File(PlatformLaunchSettingCorePage.this.coredumpPath)) {
                            PlatformLaunchSettingCorePage.this.coredumpModel.setX86coredump(true);
                        } else if (PlatformLaunchSettingCorePage.this.target.getCommander(CmdTargetTypes.HOST).isArmFile(PlatformLaunchSettingCorePage.this.coredumpPath)) {
                            PlatformLaunchSettingCorePage.this.coredumpModel.setArmcoredump(true);
                        }
                    }
                }
            }
        });
        this.corefilePath = new Text(composite, 2122);
        GridData textGridData = new GridData(1808);
        textGridData.horizontalSpan = 2;
        textGridData.heightHint = 0;
        this.corefilePath.setLayoutData((Object)textGridData);
        Label csfileLabel = new Label(composite, 0);
        csfileLabel.setText(this.resources.getString("CorePage.Label.CSfile"));
        csfileLabel.setLayoutData((Object)lGridData);
        Composite btComp2 = new Composite(composite, 0);
        btComp2.setLayout((Layout)layout);
        this.csBrowseButton = new Button(btComp2, 8);
        this.csBrowseButton.setText(this.resources.getString("BinPage.Button.Browse"));
        this.csBrowseButton.setEnabled(this.connectedDevice);
        this.csBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PlatformLaunchSettingCorePage.this.remoteCsfile = PlatformLaunchSettingCorePage.this.handleBrowseButtonSelected(PlatformLaunchSettingCorePage.this.resources.getString("CorePage.Csfile.Browse.Title"), PlatformLaunchSettingCorePage.this.DEBUG_CSFILE_PATH);
                if (PlatformLaunchSettingCorePage.this.remoteCsfile != null && PlatformLaunchSettingCorePage.this.remoteCsfile.getDate() != null) {
                    PlatformLaunchSettingCorePage.this.csvo = null;
                    PlatformLaunchSettingCorePage.this.resetControl();
                    PlatformLaunchSettingCorePage.this.originCsfilePath = PlatformLaunchSettingCorePage.this.remoteCsfile.getFullPath();
                    PlatformLaunchSettingCorePage.this.processRemoteCsfile(PlatformLaunchSettingCorePage.this.originCsfilePath);
                    if (PlatformLaunchSettingCorePage.this.csvo != null) {
                        PlatformLaunchSettingCorePage.this.coredumpModel = new CoredumpModel(PlatformLaunchSettingCorePage.this.originCoredumpPath, PlatformLaunchSettingCorePage.this.originCsfilePath, PlatformLaunchSettingCorePage.this.coredumpPath, PlatformLaunchSettingCorePage.this.csvo, CoredumpModel.LOCATION.REMOTE);
                        if (PlatformLaunchSettingCorePage.this.coredumpPath != null && !PlatformLaunchSettingCorePage.this.coredumpPath.isEmpty()) {
                            if (PlatformLaunchSettingCorePage.this.target.getCommander(CmdTargetTypes.HOST).is80386File(PlatformLaunchSettingCorePage.this.coredumpPath)) {
                                PlatformLaunchSettingCorePage.this.coredumpModel.setX86coredump(true);
                            } else if (PlatformLaunchSettingCorePage.this.target.getCommander(CmdTargetTypes.HOST).isArmFile(PlatformLaunchSettingCorePage.this.coredumpPath)) {
                                PlatformLaunchSettingCorePage.this.coredumpModel.setArmcoredump(true);
                            }
                        }
                        PlatformLaunchSettingCorePage.this.updateControl();
                    } else {
                        PlatformLaunchSettingCorePage.this.setErrorMessage(PlatformLaunchSettingCorePage.this.errorMessage);
                        PlatformLaunchSettingCorePage.this.csfilePath.setText("");
                        PlatformLaunchSettingCorePage.this.setPageComplete(false);
                    }
                }
            }
        });
        this.csLocalBrowseButton = new Button(btComp2, 8);
        this.csLocalBrowseButton.setText(this.resources.getString("CorePage.Button.Localbrowse"));
        this.csLocalBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog fd = new FileDialog(PlatformLaunchSettingCorePage.this.shell, 4100);
                fd.setText(PlatformLaunchSettingCorePage.this.resources.getString("CorePage.Csfile.Browse.Title"));
                String[] filterExt = new String[]{"*.cs"};
                fd.setFilterExtensions(filterExt);
                String localCsfile = fd.open();
                if (localCsfile != null) {
                    PlatformLaunchSettingCorePage.this.originCsfilePath = localCsfile;
                    PlatformLaunchSettingCorePage.this.processLocalCsfile(PlatformLaunchSettingCorePage.this.originCsfilePath);
                    if (PlatformLaunchSettingCorePage.this.csvo != null) {
                        PlatformLaunchSettingCorePage.this.coredumpModel = new CoredumpModel(PlatformLaunchSettingCorePage.this.originCoredumpPath, PlatformLaunchSettingCorePage.this.originCsfilePath, PlatformLaunchSettingCorePage.this.coredumpPath, PlatformLaunchSettingCorePage.this.csvo, CoredumpModel.LOCATION.LOCAL);
                        if (PlatformLaunchSettingCorePage.this.coredumpPath != null && !PlatformLaunchSettingCorePage.this.coredumpPath.isEmpty()) {
                            if (PlatformLaunchSettingCorePage.this.target.getCommander(CmdTargetTypes.HOST).is80386File(PlatformLaunchSettingCorePage.this.coredumpPath)) {
                                PlatformLaunchSettingCorePage.this.coredumpModel.setX86coredump(true);
                            } else if (PlatformLaunchSettingCorePage.this.target.getCommander(CmdTargetTypes.HOST).isArmFile(PlatformLaunchSettingCorePage.this.coredumpPath)) {
                                PlatformLaunchSettingCorePage.this.coredumpModel.setArmcoredump(true);
                            }
                        }
                        PlatformLaunchSettingCorePage.this.updateControl();
                    } else {
                        PlatformLaunchSettingCorePage.this.setErrorMessage(PlatformLaunchSettingCorePage.this.errorMessage);
                        PlatformLaunchSettingCorePage.this.csfilePath.setText("");
                        PlatformLaunchSettingCorePage.this.setPageComplete(false);
                    }
                }
            }
        });
        this.csfilePath = new Text(composite, 2122);
        this.csfilePath.setLayoutData((Object)textGridData);
        this.setControl((Control)composite);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean internalProcessCsfile(String filePath, IProgressMonitor monitor) throws FileNotFoundException {
        File extractPath = null;
        if (filePath.endsWith(".tar.gz")) {
            monitor.beginTask("", 3);
            monitor.subTask(this.resources.getString("CorePage.Progress.Extract"));
            String dirPath = PlatformFileUtil.extractTarGzFile((String)filePath, (String)"targz_extract");
            if (dirPath == null) {
                return false;
            }
            monitor.worked(1);
            extractPath = new File(dirPath);
            List files = FileUtil.findFiles((File)new File(dirPath), (String)".*.cs", (boolean)true);
            int fileCount = files.size();
            if (fileCount == 1) {
                this.csPath = ((File)files.get(0)).getAbsolutePath();
            } else {
                if (fileCount <= 1) return false;
                final String extractedPath = extractPath.getAbsolutePath();
                SWTUtil.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FileDialog fd = new FileDialog(PlatformLaunchSettingCorePage.this.shell, 4100);
                        fd.setText(PlatformLaunchSettingCorePage.this.resources.getString("CorePage.Csfile.Select.Csfile"));
                        fd.setFilterPath(extractedPath);
                        String[] filterExt = new String[]{"*.cs"};
                        fd.setFilterExtensions(filterExt);
                        PlatformLaunchSettingCorePage.this.csPath = fd.open();
                    }
                });
            }
        } else {
            monitor.beginTask("", 2);
            this.csPath = filePath;
        }
        if (this.csPath == null) {
            return false;
        }
        monitor.subTask(this.resources.getString("CorePage.Progress.ParsingCS"));
        CSFileReader csReader = new CSFileReader(this.csPath);
        this.csvo = csReader.parse();
        monitor.worked(1);
        monitor.subTask(this.resources.getString("CorePage.Progress.ReadingCS"));
        this.csFileContent = this.readCsFile(this.csPath);
        monitor.worked(1);
        if (extractPath == null || !extractPath.exists()) return true;
        FileUtil.recursiveDelete((File)extractPath);
        return true;
    }

    private void processLocalCsfile(final String filePath) {
        IWizardContainer container = this.getContainer();
        try {
            container.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 1);
                    try {
                        if (!PlatformLaunchSettingCorePage.this.internalProcessCsfile(filePath, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                            PlatformLaunchSettingCorePage.this.errorMessage = PlatformLaunchSettingCorePage.this.resources.getString("CorePage.ErrorMsg.FailedSetCsfile");
                            PlatformLaunchSettingCorePage.this.wizard.openErrorDialog(PlatformLaunchSettingCorePage.this.errorMessage);
                            return;
                        }
                    }
                    catch (FileNotFoundException e) {
                        PlatformLaunchSettingCorePage.this.errorMessage = PlatformLaunchSettingCorePage.this.resources.getString("CorePage.ErrorMsg.CannotFindCsfile");
                        PlatformLaunchSettingCorePage.this.wizard.openErrorDialog(e.toString());
                        PlatformLaunchSettingCorePage.this.logger.error(PlatformLaunchSettingCorePage.this.errorMessage, (Throwable)e);
                    }
                    catch (Exception e) {
                        PlatformLaunchSettingCorePage.this.errorMessage = PlatformLaunchSettingCorePage.this.resources.getString("CorePage.ErrorMsg.FailedSetCoredump");
                        PlatformLaunchSettingCorePage.this.wizard.openErrorDialog(e.toString());
                        PlatformLaunchSettingCorePage.this.logger.error(PlatformLaunchSettingCorePage.this.errorMessage, (Throwable)e);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            this.errorMessage = this.resources.getString("CorePage.ErrorMsg.FailedSetCoredump");
            this.wizard.openErrorDialog(e.toString());
            this.logger.error(this.errorMessage, (Throwable)e);
        }
        if (this.csvo != null) {
            this.csfilePath.setText(filePath);
        } else {
            this.errorMessage = this.resources.getString("CorePage.ErrorMsg.FailedSetCsfile");
            this.wizard.openErrorDialog(this.errorMessage);
        }
    }

    private void processRemoteCsfile(String filePath) {
        IWizardContainer container = this.getContainer();
        try {
            container.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 2);
                    try {
                        CoredumpSelectionHandler handler = new CoredumpSelectionHandler(PlatformLaunchSettingCorePage.this.target);
                        String csfile = handler.processRemoteCsfile(PlatformLaunchSettingCorePage.this.remoteCsfile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (csfile == null) {
                            PlatformLaunchSettingCorePage.this.errorMessage = PlatformLaunchSettingCorePage.this.resources.getString("CorePage.ErrorMsg.FailedDownloadCs");
                            PlatformLaunchSettingCorePage.this.wizard.openErrorDialog(PlatformLaunchSettingCorePage.this.errorMessage);
                            return;
                        }
                        if (!PlatformLaunchSettingCorePage.this.internalProcessCsfile(csfile, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                            PlatformLaunchSettingCorePage.this.errorMessage = PlatformLaunchSettingCorePage.this.resources.getString("CorePage.ErrorMsg.FailedSetCsfile");
                            PlatformLaunchSettingCorePage.this.wizard.openErrorDialog(PlatformLaunchSettingCorePage.this.errorMessage);
                            return;
                        }
                    }
                    catch (FileNotFoundException e) {
                        PlatformLaunchSettingCorePage.this.errorMessage = PlatformLaunchSettingCorePage.this.resources.getString("CorePage.ErrorMsg.CannotFindCsfile");
                        PlatformLaunchSettingCorePage.this.wizard.openErrorDialog(e.toString());
                        PlatformLaunchSettingCorePage.this.logger.error(PlatformLaunchSettingCorePage.this.errorMessage, (Throwable)e);
                    }
                    catch (Exception e) {
                        PlatformLaunchSettingCorePage.this.errorMessage = PlatformLaunchSettingCorePage.this.resources.getString("CorePage.ErrorMsg.FailedSetCoredump");
                        PlatformLaunchSettingCorePage.this.wizard.openErrorDialog(e.toString());
                        PlatformLaunchSettingCorePage.this.logger.error(PlatformLaunchSettingCorePage.this.errorMessage, (Throwable)e);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            this.errorMessage = this.resources.getString("CorePage.ErrorMsg.FailedSetCoredump");
            this.wizard.openErrorDialog(e.toString());
            this.logger.error(this.errorMessage, (Throwable)e);
        }
        if (this.csvo != null) {
            this.csfilePath.setText(filePath);
        } else {
            this.errorMessage = this.resources.getString("CorePage.ErrorMsg.FailedSetCsfile");
            this.wizard.openErrorDialog(this.errorMessage);
        }
    }

    private boolean internalProcessCoredumpfile(String filePath, IProgressMonitor monitor) {
        if (filePath.endsWith(".gz")) {
            monitor.beginTask("", 3);
            monitor.subTask(this.resources.getString("CorePage.Progress.Extract"));
            String dirPath = PlatformFileUtil.extractGzFile((String)filePath, (String)"gz_extract");
            if (dirPath == null) {
                return false;
            }
            monitor.worked(1);
            File extractDir = new File(dirPath);
            File coredumpFile = null;
            int fileCounts = extractDir.listFiles().length;
            if (fileCounts == 1) {
                coredumpFile = extractDir.listFiles()[0];
            } else if (fileCounts > 1) {
                coredumpFile = extractDir.listFiles()[0];
            } else {
                return false;
            }
            monitor.subTask(this.resources.getString("CorePage.Progress.Upload"));
            this.coredumpPath = PlatformInstances.getLaunchCommandUtil().winUploadCoredumpFile(coredumpFile.getAbsolutePath());
            monitor.worked(1);
            monitor.subTask(this.resources.getString("CorePage.Progress.RemoveTemp"));
            FileUtil.recursiveDelete((File)extractDir);
            monitor.worked(1);
        } else {
            monitor.beginTask("", 1);
            monitor.subTask(this.resources.getString("CorePage.Progress.Upload"));
            this.coredumpPath = PlatformInstances.getLaunchCommandUtil().winUploadCoredumpFile(filePath);
            monitor.worked(1);
        }
        return true;
    }

    private void processLocalCorefile(final String filePath) {
        IWizardContainer container = this.getContainer();
        try {
            container.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 1);
                    try {
                        if (!PlatformLaunchSettingCorePage.this.internalProcessCoredumpfile(filePath, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                            PlatformLaunchSettingCorePage.this.errorMessage = PlatformLaunchSettingCorePage.this.resources.getString("CorePage.ErrorMsg.FailedExtractCoredump");
                            PlatformLaunchSettingCorePage.this.wizard.openErrorDialog(PlatformLaunchSettingCorePage.this.errorMessage);
                            return;
                        }
                    }
                    catch (Exception e) {
                        PlatformLaunchSettingCorePage.this.errorMessage = PlatformLaunchSettingCorePage.this.resources.getString("CorePage.ErrorMsg.FailedSetCoredump");
                        PlatformLaunchSettingCorePage.this.wizard.openErrorDialog(e.toString());
                        PlatformLaunchSettingCorePage.this.logger.error(PlatformLaunchSettingCorePage.this.errorMessage, (Throwable)e);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            this.errorMessage = this.resources.getString("CorePage.ErrorMsg.FailedSetCoredump");
            this.wizard.openErrorDialog(e.toString());
            this.logger.error(this.errorMessage, (Throwable)e);
        }
        if (this.coredumpPath != null) {
            this.corefilePath.setText(filePath);
        } else {
            this.errorMessage = this.resources.getString("CorePage.ErrorMsg.FailedSetCoredump");
            this.wizard.openErrorDialog(this.errorMessage);
        }
    }

    private void processRemoteCorefile(String filePath) {
        IWizardContainer container = this.getContainer();
        try {
            container.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 2);
                    try {
                        CoredumpSelectionHandler handler = new CoredumpSelectionHandler(PlatformLaunchSettingCorePage.this.target);
                        String corefile = handler.processRemoteCorefile(PlatformLaunchSettingCorePage.this.remoteCorefile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (corefile == null) {
                            PlatformLaunchSettingCorePage.this.errorMessage = PlatformLaunchSettingCorePage.this.resources.getString("CorePage.ErrorMsg.FailedDownloadCoredump");
                            PlatformLaunchSettingCorePage.this.wizard.openErrorDialog(PlatformLaunchSettingCorePage.this.errorMessage);
                            return;
                        }
                        if (!PlatformLaunchSettingCorePage.this.internalProcessCoredumpfile(corefile, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                            PlatformLaunchSettingCorePage.this.errorMessage = PlatformLaunchSettingCorePage.this.resources.getString("CorePage.ErrorMsg.FailedExtractCoredump");
                            PlatformLaunchSettingCorePage.this.wizard.openErrorDialog(PlatformLaunchSettingCorePage.this.errorMessage);
                            return;
                        }
                    }
                    catch (Exception e) {
                        PlatformLaunchSettingCorePage.this.errorMessage = PlatformLaunchSettingCorePage.this.resources.getString("CorePage.ErrorMsg.FailedSetCoredump");
                        PlatformLaunchSettingCorePage.this.wizard.openErrorDialog(e.toString());
                        PlatformLaunchSettingCorePage.this.logger.error(PlatformLaunchSettingCorePage.this.errorMessage, (Throwable)e);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            this.errorMessage = this.resources.getString("CorePage.ErrorMsg.FailedSetCoredump");
            this.wizard.openErrorDialog(e.toString());
            this.logger.error(this.errorMessage, (Throwable)e);
        }
        if (this.coredumpPath != null) {
            this.corefilePath.setText(filePath);
        } else {
            this.errorMessage = this.resources.getString("CorePage.ErrorMsg.FailedSetCoredump");
            this.wizard.openErrorDialog(this.errorMessage);
        }
    }

    private void resetControl() {
        this.lModel.setText("");
        this.lBuildNum.setText("");
        this.lPkgName.setText("");
        this.lPkgVer.setText("");
        this.lProcName.setText("");
        this.lDate.setText("");
        this.lExec.setText("");
        this.coredumpInfoGroup.layout();
        this.setErrorMessage(null);
        this.setPageComplete(false);
    }

    private void updateControl() {
        this.lModel.setText(": " + this.csvo.getHeader().getModel());
        this.lBuildNum.setText(": " + this.csvo.getHeader().getBuildNumber());
        String name = this.csvo.getHeader().getPackageName();
        String pkgType = this.csvo.getHeader().getPackageType();
        if (pkgType != null) {
            name = String.valueOf(name) + " (" + pkgType + ")";
        }
        this.lPkgName.setText(": " + name);
        this.lPkgVer.setText(": " + this.csvo.getHeader().getPackageVersion());
        this.lProcName.setText(": " + this.csvo.getHeader().getProcessName());
        this.lDate.setText(": " + this.csvo.getHeader().getCrashDate());
        this.binaryPath = this.csvo.getHeader().getCrashExePath();
        this.lExec.setText(": " + this.binaryPath);
        this.coredumpInfoGroup.layout();
        this.setErrorMessage(null);
        String arch = "";
        if (this.coredumpModel.isX86coredump()) {
            arch = "80386";
        } else if (this.coredumpModel.isArmcoredump()) {
            arch = "ARM";
        }
        this.setMessage(String.valueOf(this.resources.getString("CorePage.Msg.SetCoredump")) + String.format(" (%s)", arch));
        this.setPageComplete(true);
    }

    private String readCsFile(String filePath) {
        StringBuilder sb;
        block7: {
            BufferedReader br = null;
            sb = null;
            try {
                try {
                    br = new BufferedReader(new FileReader(filePath));
                    sb = new StringBuilder();
                    String line = br.readLine();
                    while (line != null) {
                        sb.append(line);
                        sb.append('\n');
                        line = br.readLine();
                    }
                }
                catch (Exception e) {
                    String msg = String.format(this.resources.getString("CorePage.ErrorMsg.FailedReadCsfile"), filePath);
                    this.logger.error(msg, (Throwable)e);
                    IOUtil.tryClose((Object[])new Object[]{br});
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{br});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{br});
        }
        if (sb != null) {
            return sb.toString();
        }
        return "";
    }

    private FileEntry handleBrowseButtonSelected(String title, String defaultPath) {
        Shell shell = this.getAvailableShell();
        FileEntry path = PlatformLaunchUtil.selectRemoteFile((Shell)shell, (String)title, (String)defaultPath);
        return path;
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public CoredumpModel getCoredumpModel() {
        return this.coredumpModel;
    }

    public String getCsFileContent() {
        return this.csFileContent;
    }
}

