/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.createcsharp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CSSolutionInfo {
    private static final String PROJECT_FORMAT = "Project(\"%s\") = \"%s\", \"%s\", \"{%s}\"";
    private static final String ENDPROJECT = "EndProject";
    private static final String SOLUTION_CONFIG_FORMAT = "\t\t%s = %s";
    private static final String PROJECT_CONFIG_FORMAT = "\t\t{%s}.%s.%s = %s";
    private static final String GLOBALSECTION_FORMAT = "\tGlobalSection(%s) = %s";
    private static final String ENDGLOBALSECTION = "\tEndGlobalSection";
    private static final String PRESOLUTION = "preSolution";
    private static final String POSTSOLUTION = "postSolution";
    private List<CSProjectInfo> projects = new ArrayList<CSProjectInfo>();

    public void addProject(String name, String projectFile, String guid) {
        CSProjectInfo pInfo = new CSProjectInfo();
        pInfo.name = name;
        pInfo.projectFile = projectFile;
        pInfo.guid = guid;
        this.projects.add(pInfo);
    }

    public boolean makeSolutionFile(String filepath) {
        File solutionFile = new File(filepath);
        File solutionParent = solutionFile.getParentFile();
        if (solutionParent == null) {
            return false;
        }
        String solutionPath = solutionParent.getAbsolutePath();
        if (solutionFile.exists()) {
            solutionFile.delete();
        }
        try {
            FileWriter fw = new FileWriter(solutionFile);
            this.writeHeader(fw);
            this.writeProject(fw, solutionPath);
            this.writeGlobal(fw);
            fw.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean writeHeader(FileWriter fw) throws IOException {
        fw.write("Microsoft Visual Studio Solution File, Format Version 12.00\n");
        fw.write("# Visual Studio 14\n");
        fw.write("VisualStudioVersion = 14.0.25420.1\n");
        fw.write("MinimumVisualStudioVersion = 10.0.40219.1\n");
        fw.flush();
        return true;
    }

    private boolean writeProject(FileWriter fw, String solutionPath) throws IOException {
        for (CSProjectInfo project : this.projects) {
            String projectname = project.name;
            String projectpath = new File(solutionPath).toPath().relativize(new File(project.projectFile).toPath()).toString();
            String projectguid = project.guid;
            String prjstr = String.format(PROJECT_FORMAT, "{FAE04EC0-301F-11D3-BF4B-00C04F79EFBC}", projectname, projectpath, projectguid);
            fw.write(prjstr);
            fw.write("\n");
            fw.write(ENDPROJECT);
            fw.write("\n");
        }
        fw.flush();
        return true;
    }

    private boolean writeGlobal(FileWriter fw) throws IOException {
        fw.write("Global\n");
        this.writeGlobalSection(fw, "SolutionConfigurationPlatforms", PRESOLUTION);
        this.writeGlobalSection(fw, "ProjectConfigurationPlatforms", POSTSOLUTION);
        this.writeGlobalSection(fw, "SolutionProperties", PRESOLUTION);
        fw.write("EndGlobal\n");
        fw.flush();
        return true;
    }

    private boolean writeGlobalSection(FileWriter fw, String sectionName, String sectionType) throws IOException {
        String sectionHeader = String.format(GLOBALSECTION_FORMAT, sectionName, sectionType);
        fw.write(sectionHeader);
        fw.write("\n");
        List<String> configTypes = Arrays.asList("Debug|Any CPU", "Release|Any CPU");
        if (sectionName.equals("SolutionConfigurationPlatforms")) {
            for (String config : configTypes) {
                String line = String.format(SOLUTION_CONFIG_FORMAT, config, config);
                fw.write(line);
                fw.write("\n");
            }
        } else if (sectionName.equals("ProjectConfigurationPlatforms")) {
            ArrayList<String> projectGuids = new ArrayList<String>();
            for (CSProjectInfo project : this.projects) {
                projectGuids.add(project.guid);
            }
            List<String> actives = Arrays.asList("ActiveCfg", "Build.0");
            for (String guid : projectGuids) {
                for (String config : configTypes) {
                    for (String active : actives) {
                        fw.write(String.format(PROJECT_CONFIG_FORMAT, guid, config, active, config));
                        fw.write("\n");
                    }
                }
            }
        } else if (sectionName.equals("SolutionProperties")) {
            fw.write("\t\tHideSolutionNode = FALSE\n");
        }
        fw.write(ENDGLOBALSECTION);
        fw.write("\n");
        return true;
    }

    static class CSProjectInfo {
        public String name;
        public String projectFile;
        public String guid;

        CSProjectInfo() {
        }
    }
}

