/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.sign;

import java.io.File;
import java.io.FileNotFoundException;
import org.kohsuke.args4j.Option;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractSecurityProfileCLI;

@TizenSubCommand(name="remove", usage="Remove the specified security profile.")
public class SecurityProfileRemoveCLI
extends AbstractSecurityProfileCLI {
    @Option(name="-n", aliases={"--name"}, required=true, metaVar="<profile name>", usage="Specify the name of the security profile to remove.")
    private String name;

    @Override
    public int execute() {
        int result = 0;
        this.log.trace("Begin SecurityProfileRemoveCLI...");
        File file = this.getProfileXMLFile();
        if (file == null) {
            this.progressLog.error("Not exist the default path of security profiles.");
            return 2;
        }
        SigningProfileContainer container = null;
        try {
            container = this.readXML(file);
            this.log.trace("Read XML: {} profile found.", (Object)container.getProfiles().size());
        }
        catch (FileNotFoundException e) {
            this.progressLog.error("Not found a file of security profiles. Please check specified path.");
            return 2;
        }
        SigningProfile profile = container.getProfileByName(this.name);
        if (profile == null) {
            this.progressLog.error("There is no '{}' profile in security profiles. Please check the profile list by 'tizen security-profiles list' command.", (Object)this.name);
            return 2;
        }
        try {
            boolean bRemoved = container.removeProfile(profile);
            if (bRemoved) {
                SigningProfile aprofile;
                if (container.getActiveProfileName() == null && (aprofile = container.getFirstProfile()) != null) {
                    container.setActiveProfile(aprofile);
                }
                this.writeXML(container, file);
                this.progressLog.info("Succeed to remove '{}' profile.", (Object)this.name);
            } else {
                this.log.trace("Failed to remove a specified profile.");
            }
        }
        catch (FileNotFoundException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return 1;
        }
        this.log.trace("Finish SecurityProfileRemoveCLI...");
        return result;
    }
}

