/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.Factory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.builder.Resource;
import org.tizen.common.builder.ResourceLayer;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Policy;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.core.command.policy.PolicyRegistry;
import org.tizen.common.core.command.prompter.NopPrompter;
import org.tizen.common.core.command.zip.ZipCommand;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.Filter;
import org.tizen.common.file.IResource;
import org.tizen.common.file.SimpleFileFilter;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.file.VirtualFileHandler;
import org.tizen.common.file.filter.WildCardFilterFactory;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeCommand;
import org.tizen.ncli.subcommands.packages.PackageCLICommandData;
import org.tizen.ncli.subcommands.packages.PackageData;
import org.tizen.ncli.subcommands.packages.PackageNativeCLICommand;
import org.tizen.ncli.subcommands.packages.PackageProject;
import org.tizen.ncli.subcommands.packages.PackageWebMultiCommand;
import org.tizen.ncli.subcommands.packages.WebProject;
import org.tizen.ncli.subcommands.sign.SignCLICommand;
import org.tizen.ncli.util.DirectoryUtil;
import org.tizen.ssilib.SSIData;
import org.tizen.ssilib.SSIMacro;
import org.tizen.ssilib.SSIProcess;
import org.tizen.ssilib.SSITargetType;
import org.w3c.dom.Document;

public class PackageCLICommand
extends AbstractSubCommand<PackageCLICommandData> {
    protected FileHandler fileHandler = new StandardFileHandler();
    protected String projectPath;
    protected String projectName;
    protected String outputPath = null;
    protected static final String TIZEN_WEB_CONFIG_FILE = "config.xml";
    protected static final String SIGNATURE_FILE = "signature1.xml";
    protected static final String AUTHOR_SIGNATURE_FILE = "author-signature.xml";
    protected static final String BUILD_RESULT_DIR = ".buildResult";
    protected PackageCLICommandData data = new PackageCLICommandData();
    protected SimpleFileFilter filter = new SimpleFileFilter(true);
    protected FactoryWithArgument<Filter, String> filterFactory = new WildCardFilterFactory();
    protected static final String RESOURCE_LAYER_START = "start";
    private String profilesPath;
    private String profileName;
    private Configuration config = new Configuration();
    private String configPath;
    private Document configDoc;
    private List<String> refPaths = null;
    private boolean isWebWidget = false;

    private boolean isNativeProject(String targetPath) {
        String projPath = new File(targetPath).getParent();
        if (projPath == null) {
            throw new UnexpectedException(2, "Failed to check whether the project type is native.");
        }
        return BuildNativeCommand.validateProject(projPath);
    }

    private boolean isWebProject(String targetPath) {
        String projPath = new File(targetPath).getParent();
        if (projPath == null) {
            throw new UnexpectedException(2, "Failed to check whether the project is web.");
        }
        File projFile = new File(projPath);
        if (!new File(projFile, ".tproject").exists()) {
            return false;
        }
        return new File(projFile, TIZEN_WEB_CONFIG_FILE).exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PackageCLICommandData call() {
        String authorFileName;
        SignCLICommand signCmd;
        block16: {
            this.log.debug("Base project directory: {}", (Object)this.projectPath);
            this.configPath = this.findAndGetFileName(this.workingDir, TIZEN_WEB_CONFIG_FILE);
            if (this.configPath == null) {
                this.configPath = this.findAndGetFileName(new File(this.projectPath), TIZEN_WEB_CONFIG_FILE);
            }
            if (this.configPath == null) {
                this.progressLog.error(String.format("Not found tizen web project in %s", this.projectPath));
                return null;
            }
            try {
                this.configDoc = WebProject.getDocument(this.configPath);
                if (this.configDoc == null) {
                    this.progressLog.error("Error config file is not exist");
                    return null;
                }
                this.projectName = WebProject.getProjectName(this.configDoc);
                if (this.projectName == null) {
                    this.progressLog.error("Error occured during getting project name from config file");
                    return null;
                }
            }
            catch (Exception e) {
                this.progressLog.error("Error occured during getting project config file", (Object)e.getMessage());
                return null;
            }
            if (this.refPaths != null && !this.refPaths.isEmpty()) {
                PackageWebMultiCommand cmd = new PackageWebMultiCommand();
                cmd.setWorkingDir(this.workingDir);
                cmd.setProfileName(this.profileName);
                cmd.setReferencePaths(this.refPaths);
                cmd.setOutputPath(this.outputPath);
                return (PackageCLICommandData)cmd.runCommand();
            }
            signCmd = new SignCLICommand();
            signCmd.setWorkingDir(this.workingDir);
            if (this.profileName != null && !this.profileName.isEmpty()) {
                this.profilesPath = this.config.getValue("profiles.path");
                if (this.profilesPath == null) {
                    this.profilesPath = this.config.getValue("default.profiles.path");
                }
                if (this.profilesPath != null && !this.profilesPath.isEmpty()) {
                    signCmd.setProfileName(this.profileName);
                    break block16;
                } else {
                    this.log.error(String.format("The path of '%s' does not exist. Update 'tizen cli-config -g %s='valid path'.", "profiles.path", "profiles.path"));
                    this.progressLog.error(String.format("The path of '%s' does not exist. Update 'tizen cli-config -g %s='valid path'.", "profiles.path", "profiles.path"));
                    return null;
                }
            }
            signCmd.setUseDefaultCertificate(true);
        }
        signCmd.runCommand();
        String fileName = this.findAndGetFileName(this.workingDir, SIGNATURE_FILE);
        if (fileName == null) {
            this.progressLog.info("Warning: Not found tizen signature file");
        }
        if ((authorFileName = this.findAndGetFileName(this.workingDir, AUTHOR_SIGNATURE_FILE)) == null) {
            this.progressLog.info("Warning: Not found tizen author signature file");
        }
        String[] excludes = this.getDefaultExcludes();
        this.log.debug("Excludes File Pattern: {}", (Object)CollectionUtil.toString((Object)excludes));
        this.progressLog.info("Excludes File Pattern: {}", (Object)CollectionUtil.toString((Object)excludes));
        ResourceLayer startLayer = new ResourceLayer(RESOURCE_LAYER_START, (FileHandler)new VirtualFileHandler());
        Resource[] resources = null;
        try {
            resources = this.getResources(this.workingDir.getAbsolutePath(), startLayer, null, excludes);
        }
        catch (IOException e) {
            this.log.error("Error occured during reading resource", (Object)e.getMessage());
            return null;
        }
        File outputFile = new File(this.outputPath + File.separator + this.projectName + "." + "wgt");
        this.data.setWgtPath(outputFile.getAbsolutePath());
        this.log.debug("Widget path: {}", (Object)outputFile.getAbsolutePath());
        if (outputFile.exists()) {
            outputFile.delete();
        }
        this.zipFiles(outputFile.getAbsolutePath(), this.workingDir.getAbsolutePath(), resources);
        return this.data;
    }

    private boolean validateProfilesPath() {
        boolean result = false;
        if (this.profilesPath != null) {
            File profiles = new File(this.profilesPath);
            if (profiles.exists()) {
                result = true;
            } else {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.SIGN_NO_PROFILES, (Object)this.profilesPath));
            }
        } else {
            this.progressLog.info(TizenCLIMessages.SIGN_NO_CONFIG_PROFILES);
        }
        return result;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setProfileName(String profile) {
        this.profileName = profile;
    }

    public void setReferencePaths(List<String> refPaths) {
        this.refPaths = refPaths;
    }

    public List<String> getReferencePaths() {
        return this.refPaths;
    }

    private String findAndGetFileName(File baseDir, String fileName) {
        File[] filesAndDirs = baseDir.listFiles();
        if (null == filesAndDirs) {
            return null;
        }
        for (File file : filesAndDirs) {
            String name = file.getName();
            if (!name.equals(fileName) || !file.isFile()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource[] getResources(String baseDir, ResourceLayer resourceLayer, String[] includes, String[] excludes) throws IOException {
        List files = FileUtil.findFiles((File)new File(baseDir), (String)".*", (boolean)true);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        FileHandler fh = resourceLayer.getFileHandler();
        this.setIncludes(includes);
        this.setExcludes(excludes);
        for (File file : files) {
            String filePath = file.getPath();
            if (!FilenameUtil.equals((String)filePath, (String)baseDir) && !this.filter.accept(baseDir, FilenameUtil.getRelativePath((String)baseDir, (String)filePath))) {
                this.log.debug("Ignore File: {}", (Object)filePath);
                this.progressLog.info("Ignore File: {}", (Object)filePath);
                continue;
            }
            Resource resource = new Resource(resourceLayer, filePath);
            String dir = null;
            dir = file.isFile() ? file.getParent() : filePath;
            if (!fh.is(dir, FileHandler.Attribute.EXISTS)) {
                fh.makeDirectory(dir, true);
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                resource.setContents((InputStream)is);
                resources.add(resource);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{is});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{is});
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public void setIncludes(String[] includes) {
        this.filter.clearIncludes();
        if (null != includes) {
            for (String include : includes) {
                this.filter.addIncludes(new Filter[]{(Filter)this.filterFactory.create((Object)include)});
            }
        }
    }

    public void setExcludes(String[] excludes) {
        this.filter.clearExcludes();
        if (null != excludes) {
            for (String exclude : excludes) {
                this.filter.addExcludes(new Filter[]{(Filter)this.filterFactory.create((Object)exclude)});
            }
        }
    }

    private void zipFiles(String wgtPath, String baseDir, Resource[] resources) {
        ZipCommand command = new ZipCommand(baseDir, (IResource[])resources, wgtPath);
        Executor executor = new Executor((Factory)new Factory<ExecutionContext>(){

            public ExecutionContext create() {
                return new ExecutionContext(new PolicyRegistry(new Policy[0]), (Prompter)new NopPrompter(), PackageCLICommand.this.fileHandler);
            }
        });
        executor.execute(new Command[]{command});
    }

    protected boolean exists(String path) throws IOException {
        return this.fileHandler.is(path, FileHandler.Attribute.EXISTS);
    }

    protected boolean isValidRoot(String path) throws IOException {
        String projectFilePath = FilenameUtil.addTailingPath((String)path, (String)".project");
        return this.fileHandler.is(projectFilePath, FileHandler.Attribute.EXISTS);
    }

    protected String[] getDefaultExcludes() {
        return new String[]{".manifest.tmp", ".delta.lst"};
    }

    protected void zipFiles(String wgtPath, String baseDir) {
        this.zipFiles(wgtPath, baseDir, null);
    }

    public PackageData getSSIData(String workingDir, String projectPath) {
        if (PackageProject.isNativeProject(projectPath)) {
            return PackageNativeCLICommand.getEnv(workingDir, projectPath, this.log);
        }
        if (PackageProject.isWebProject(projectPath)) {
            return PackageProject.getWebSSIData(workingDir, projectPath, this.log);
        }
        return null;
    }

    public void processSSI() {
        String sdkPath = InstallPathConfig.getSDKPath();
        SSIProcess ssi = new SSIProcess(sdkPath);
        PackageData data2 = this.getSSIData(this.workingDir.toString(), this.projectPath);
        SSIData ssiData = new SSIData();
        ssiData.putProperty("sdk.path", (Object)sdkPath);
        ssiData.putProperty("project.path", (Object)this.projectPath);
        ssiData.putProperty("app.id", (Object)data2.getAppId());
        ssiData.putProperty("app.type", (Object)data2.getProjType());
        ssiData.putProperty("build.config", (Object)data2.getSbiConfig());
        ssiData.putProperty("build.arch", (Object)data2.getArchitecture());
        ssiData.putProperty("project.output.path", (Object)this.workingDir.toString());
        boolean result = false;
        File ssiConfFile = new File(this.projectPath, "Build/SSI.xml");
        if (ssiConfFile.exists() && (result = ssi.analisysPackageScript(ssiConfFile, ssiData, "1.0"))) {
            ssi.setHomePath(this.projectPath + "/Build");
        }
        if (!result && (ssiConfFile = new File(sdkPath, "tools/ide/resources/common/Build/SSI.xml")).exists() && (result = ssi.analisysPackageScript(ssiConfFile, ssiData))) {
            ssi.setHomePath(sdkPath + "/tools/ide/resources/common/Build");
        }
        File tempFile = null;
        try {
            tempFile = DirectoryUtil.createTempDirectory();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (this.refPaths == null || this.refPaths.isEmpty()) {
            if (this.isWebWidget) {
                ssi.procStructuring("web_widget", new SSITargetType[]{new SSITargetType("project", "web", this.projectPath, this.workingDir.toString(), (SSIMacro.Runner)new PackageProject.MacroRunner(data2))}, tempFile.toString(), this.log);
            } else {
                ssi.procStructuring("wgt", new SSITargetType[]{new SSITargetType("project", "web", this.projectPath, this.workingDir.toString(), (SSIMacro.Runner)new PackageProject.MacroRunner(data2))}, tempFile.toString(), this.log);
            }
        } else {
            int nativeCnt = 0;
            int webCnt = 0;
            ArrayList<SSITargetType> targets = new ArrayList<SSITargetType>();
            targets.add(new SSITargetType("project", "web", this.projectPath, this.workingDir.toString(), (SSIMacro.Runner)new PackageProject.MacroRunner(data2)));
            for (String target : this.refPaths) {
                PackageData data3 = this.getSSIData(target, null);
                if (data3 == null) continue;
                if (this.isNativeProject(target)) {
                    targets.add(new SSITargetType("project", "native", null, target, (SSIMacro.Runner)new PackageProject.MacroRunner(data3)));
                    ++nativeCnt;
                    continue;
                }
                if (!this.isWebProject(target)) continue;
                targets.add(new SSITargetType("project", "web", null, target, (SSIMacro.Runner)new PackageProject.MacroRunner(data3)));
                ++webCnt;
            }
            targets.add(new SSITargetType("package", "", null, null, null));
            if (webCnt > 0 && nativeCnt > 0) {
                ssi.procStructuring("hybrid2", targets.toArray(new SSITargetType[targets.size()]), tempFile.toString(), this.log);
            } else if (nativeCnt > 0) {
                ssi.procStructuring("hybrid", targets.toArray(new SSITargetType[targets.size()]), tempFile.toString(), this.log);
            } else if (webCnt > 0) {
                ssi.procStructuring("web_widget", targets.toArray(new SSITargetType[targets.size()]), tempFile.toString(), this.log);
            }
        }
        File tmp = new File(tempFile, ".manifest.tmp");
        if (tmp.exists()) {
            tmp.delete();
        }
        SignCLICommand signCmd = new SignCLICommand();
        signCmd.setWorkingDir(tempFile);
        signCmd.setProfileName(this.profileName);
        signCmd.runCommand();
        if (tmp.exists()) {
            tmp.delete();
        }
        CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
        File outFile = new File(this.outputPath + File.separator + this.projectName + "." + "wgt");
        if (outFile.exists()) {
            outFile.delete();
        }
        ZipCommand zipCmd = new ZipCommand(tempFile.toString(), outFile.toString());
        zipCmd.setExcludes(new String[]{".manifest.tmp"});
        executor.execute(new Command[]{zipCmd});
        DirectoryUtil.deleteDirectory(tempFile);
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }
}

