/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.realm;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.MapUtil;
import org.tizen.common.verrari.Realm;
import org.tizen.common.verrari.Template;
import org.tizen.common.verrari.TemplateException;
import org.tizen.common.verrari.realm.CommonRealm;
import org.tizen.common.verrari.realm.Query;
import org.tizen.common.verrari.template.StandardTemplate;

public class JarRealm
extends CommonRealm {
    @Override
    public Template getTemplate(String id) throws IOException {
        Template template;
        Query templateQuery = this.getTemplateQuery(this);
        Map modelMap = MapUtil.asMap((Object[][])new Object[][]{{"id", id}});
        this.logger.trace("Map :{}", (Object)modelMap);
        String query = templateQuery.query(modelMap);
        this.logger.trace("Query :{}", (Object)query);
        URL url = new URL(query);
        InputStream in = null;
        try {
            in = url.openStream();
            if (in == null) {
                throw new IOException("Template[" + id + "] not found");
            }
            template = this.getTemplate(in);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{in});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{in});
        return template;
    }

    public Template getTemplate(InputStream in) throws IOException {
        byte[] bytes = IOUtil.getBytes((InputStream)in);
        try {
            StandardTemplate template = new StandardTemplate(bytes);
            return template;
        }
        catch (TemplateException e) {
            throw new IOException(e);
        }
    }

    public String toString() {
        return String.valueOf((String)this.attributes.get("id")) + "@" + Realm.class.getSimpleName();
    }
}

