/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.template;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.util.IOUtil;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.common.verrari.ITemplate;
import org.tizen.common.verrari.ITemplateEngine;
import org.tizen.common.verrari.ITemplateProvider;
import org.tizen.common.verrari.engine.TemplateEngineFactory;
import org.tizen.common.verrari.model.ModelManager;
import org.tizen.common.verrari.template.InMemoryTemplate;
import org.tizen.common.verrari.template.Mapper;
import org.tizen.common.verrari.template.TemplateManager;
import org.tizen.common.verrari.util.BufferFactory;

public class StandardMapper
implements Mapper {
    protected static final String PROP_KEY_TEMPLATE = "key";
    protected static final String PROP_VALUE_TEMPLATE = "value";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<String, String> mappings = new HashMap<String, String>();

    @Override
    public void setMappings(Map<String, String> mappings) {
        this.logger.info("Mappings :{}", mappings);
        this.mappings = Collections.unmodifiableMap(mappings);
    }

    @Override
    public String map(String value) {
        for (String key : this.mappings.keySet()) {
            String string;
            if (!Pattern.matches(key, value)) continue;
            String target = this.mappings.get(key);
            ITemplateEngine engine = TemplateEngineFactory.getInstance().create();
            TemplateManager templates = new TemplateManager();
            engine.setTemplateProvider((ITemplateProvider)templates);
            InMemoryTemplate keyTemplate = null;
            InMemoryTemplate valueTemplate = null;
            try {
                keyTemplate = new InMemoryTemplate(key.getBytes(), "utf-8", (FactoryWithArgument)BufferFactory.getInstance());
                valueTemplate = new InMemoryTemplate(target.getBytes(), "utf-8", (FactoryWithArgument)BufferFactory.getInstance());
                templates.addTemplate(PROP_KEY_TEMPLATE, (ITemplate)keyTemplate);
                templates.addTemplate(PROP_VALUE_TEMPLATE, (ITemplate)valueTemplate);
                ByteArrayOutputStream keyOut = new ByteArrayOutputStream();
                engine.generate(PROP_KEY_TEMPLATE, (IModelProvider)new ModelManager(), (OutputStream)keyOut);
                ByteArrayOutputStream valueOut = new ByteArrayOutputStream();
                engine.generate(PROP_VALUE_TEMPLATE, (IModelProvider)new ModelManager(), (OutputStream)valueOut);
                String keyStr = keyOut.toString();
                String valueStr = valueOut.toString();
                this.logger.info("Key :{}, Value :{}", (Object)keyStr, (Object)valueStr);
                string = value.replaceAll(keyStr, valueStr);
            }
            catch (Exception e) {
                try {
                    this.logger.error("No effective mapping for {}", (Object)value, (Object)e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{keyTemplate, valueTemplate});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{keyTemplate, valueTemplate});
                continue;
            }
            IOUtil.tryClose((Object[])new Object[]{keyTemplate, valueTemplate});
            return string;
        }
        return value;
    }
}

