/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Section;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfField;
import com.lowagie.text.rtf.field.RtfTOCEntry;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfSection
extends RtfElement {
    protected RtfParagraph title = null;
    protected ArrayList items = new ArrayList();

    public RtfSection(RtfDocument rtfDocument, Section section) {
        super(rtfDocument);
        try {
            Object object;
            Object object2;
            Object object3;
            if (section.getTitle() != null) {
                this.title = (RtfParagraph)rtfDocument.getMapper().mapElement(section.getTitle())[0];
            }
            if (this.document.getAutogenerateTOCEntries()) {
                object3 = new StringBuffer();
                object2 = section.getTitle().iterator();
                while (object2.hasNext()) {
                    object = (RtfBasicElement[])object2.next();
                    if (object.type() != 10) continue;
                    ((StringBuffer)object3).append(((Chunk)object).getContent());
                }
                if (((StringBuffer)object3).toString().trim().length() > 0) {
                    object = new RtfTOCEntry(((StringBuffer)object3).toString());
                    ((RtfField)object).setRtfDocument(this.document);
                    this.items.add(object);
                }
            }
            object3 = section.iterator();
            while (object3.hasNext()) {
                object2 = (Element)object3.next();
                object = rtfDocument.getMapper().mapElement((Element)object2);
                for (int i = 0; i < ((RtfBasicElement[])object).length; ++i) {
                    if (object[i] == null) continue;
                    this.items.add(object[i]);
                }
            }
            this.updateIndentation(section.getIndentationLeft(), section.getIndentationRight(), section.getIndentation());
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(RtfParagraph.PARAGRAPH);
        if (this.title != null) {
            this.title.writeContent(outputStream);
        }
        for (int i = 0; i < this.items.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.items.get(i);
            rtfBasicElement.writeContent(outputStream);
        }
    }

    public void setInTable(boolean bl) {
        super.setInTable(bl);
        for (int i = 0; i < this.items.size(); ++i) {
            ((RtfBasicElement)this.items.get(i)).setInTable(bl);
        }
    }

    public void setInHeader(boolean bl) {
        super.setInHeader(bl);
        for (int i = 0; i < this.items.size(); ++i) {
            ((RtfBasicElement)this.items.get(i)).setInHeader(bl);
        }
    }

    private void updateIndentation(float f, float f2, float f3) {
        if (this.title != null) {
            this.title.setIndentLeft((int)((double)this.title.getIndentLeft() + (double)f * 20.0));
            this.title.setIndentRight((int)((double)this.title.getIndentRight() + (double)f2 * 20.0));
        }
        for (int i = 0; i < this.items.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.items.get(i);
            if (rtfBasicElement instanceof RtfSection) {
                ((RtfSection)rtfBasicElement).updateIndentation(f + f3, f2, 0.0f);
                continue;
            }
            if (!(rtfBasicElement instanceof RtfParagraph)) continue;
            ((RtfParagraph)rtfBasicElement).setIndentLeft((int)((double)((RtfParagraph)rtfBasicElement).getIndentLeft() + (double)(f + f3) * 20.0));
            ((RtfParagraph)rtfBasicElement).setIndentRight((int)((double)((RtfParagraph)rtfBasicElement).getIndentRight() + (double)f2 * 20.0));
        }
    }
}

