/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sdb.command;

import org.tizen.common.sdb.command.ApplicationCommand;
import org.tizen.common.sdb.command.SdbCommandHelper;
import org.tizen.common.sdb.command.message.PkgcmdErrorType;
import org.tizen.common.sdb.command.receiver.PkgCmdReceiver;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.service.ApplicationCmdService;

public class ReInstallCommand
extends ApplicationCommand {
    protected String APP_REINSTALL_COMMAND = "pkgcmd -q -r -t \"%s\" -n \"%s\" %s";
    protected String pkgType = null;
    protected String pkgId = null;
    protected int timeout = -1;
    protected String args = "";

    public ReInstallCommand(IDevice device, String pkgType, String pkgId, int timeout, ITizenConsoleManager console) {
        super(device, console);
        this.pkgType = pkgType;
        this.pkgId = pkgId;
        this.timeout = timeout;
    }

    @Override
    protected void executeCommand() throws Exception {
        if (ApplicationCommand.isAppCmdSupported(this.getDevice())) {
            ApplicationCmdService appcmd = this.getApplicationCmdService();
            if (!appcmd.reinstallPackage(this.pkgId, (IShellOutputReceiver)this.receiver, null)) {
                this.newCoreException("Reinstall failed: " + this.pkgId, null);
            }
        } else {
            this.helper = new SdbCommandHelper(this.device, this.getConsole(), new PkgCmdReceiver(this.getConsole()));
            this.getConsole().print("Reinstall: ");
            this.helper.runPkgCmd(this.getCommand(), new PkgcmdErrorType(), this.timeout);
        }
    }

    protected String getCommand() {
        String command = String.format(this.APP_REINSTALL_COMMAND, this.getPkgType(), this.getPkgId(), this.getArgs());
        return command;
    }

    protected String getPkgType() {
        return this.pkgType;
    }

    protected String getPkgId() {
        return this.pkgId;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    protected String getArgs() {
        if (this.isDebugMode()) {
            this.args = String.valueOf(this.args) + "-G";
        }
        return this.args;
    }

    private boolean isDebugMode() {
        PlatformCapability capa = null;
        boolean isDebugMode = false;
        try {
            capa = this.device.getPlatformCapability();
            isDebugMode = "enabled".equals(capa.getPkgcmdDebugModeSupport());
        }
        catch (Exception e) {
            isDebugMode = false;
            this.logger.debug("Failed to get platform capability.", (Throwable)e);
        }
        return isDebugMode;
    }
}

