/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.service;

import java.io.IOException;
import java.nio.file.Paths;
import org.tizen.sdb.CommandResponse;
import org.tizen.sdb.command.Dlog;
import org.tizen.sdb.command.Install;
import org.tizen.sdb.command.Kill;
import org.tizen.sdb.command.Launch;
import org.tizen.sdb.command.PackageInfo;
import org.tizen.sdb.command.Uninstall;
import org.tizen.sdb.command.receiver.OutputReceiver;
import org.tizen.sdb.item.PackageItem;
import org.tizen.sdblib.Device;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.command.CommandFactory;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.ShellCommandUnresponsiveException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.receiver.AppCmdReceiver;
import org.tizen.sdblib.receiver.NewSdbOutputReceiver;
import org.tizen.sdblib.service.IAppCmdProgressMonitor;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.tizen.sdblib.util.Assert;
import org.tizen.sdblib.util.Log;
import org.tizen.sdblib.util.StringUtil;

public class ApplicationCmdService {
    protected Device device;
    protected String appPackagePath;
    private static final String LOG_TAG = "ApplicationCmdService";

    public ApplicationCmdService(Device device) {
        Assert.notNull(device);
        this.device = device;
    }

    public boolean installPackage(PackageType type, String pkgfilePath, String pkgID, String tepPath) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.installPackage(type, pkgfilePath, pkgID, tepPath, null, null);
    }

    public boolean installPackage(PackageType type, String pkgfilePath, String pkgID, String tepPath, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.installPackage(type, pkgfilePath, pkgID, tepPath, receiver, null);
    }

    public boolean installPackage(PackageType type, String pkgfilePath, String pkgID, String tepPath, IAppCmdProgressMonitor monitor) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.installPackage(type, pkgfilePath, pkgID, tepPath, null, monitor);
    }

    public boolean installPackage(PackageType type, String pkgfilePath, String pkgID, String tepPath, IShellOutputReceiver receiver, IAppCmdProgressMonitor monitor) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            return this.installPackageForPrev(type, pkgfilePath, pkgID, tepPath, receiver, monitor);
        }
        this.setSubTask(monitor, "Sending the install command to the device");
        Install install = new Install();
        if (pkgID != null && !pkgID.isEmpty()) {
            install.reinstallPackage(pkgID, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
        } else if (tepPath == null || tepPath.isEmpty()) {
            install.installPackage(pkgfilePath, true, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
        } else {
            install.installPackageWithTep(pkgfilePath, tepPath, true, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
        }
        CommandResponse response = install.getResponse();
        if (response != null && response.getStatusCode() == 0) {
            return true;
        }
        Log.e(LOG_TAG, "Install service in the device has failed");
        return false;
    }

    private boolean installPackageForPrev(PackageType type, String pkgfilePath, String pkgID, String tepPath, IShellOutputReceiver receiver, IAppCmdProgressMonitor monitor) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String remotePkgfilePath = null;
        String remoteTepfilePath = null;
        String command = null;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        boolean result = false;
        if (pkgID == null) {
            remotePkgfilePath = this.transferPackage(pkgfilePath, monitor);
            if (remotePkgfilePath == null) {
                Log.e(LOG_TAG, "Fail to transfer package file.");
                return false;
            }
            if (tepPath != null && (remoteTepfilePath = this.transferPackage(pkgfilePath, monitor)) == null) {
                Log.e(LOG_TAG, "Fail to transfer package file.");
                return false;
            }
        }
        command = "install:" + type.getStringName() + ":" + remotePkgfilePath + ":" + pkgID + ":" + remoteTepfilePath;
        this.setSubTask(monitor, "Sending the install command to the device");
        appCmdReturn = this.runAppCmd(command, receiver);
        if (appCmdReturn.getAppCmdExitcode() == 0) {
            result = true;
        } else {
            Log.e(LOG_TAG, "Install service in the device has failed.");
        }
        return result;
    }

    public boolean reinstallPackage(String packageID, IShellOutputReceiver receiver, IAppCmdProgressMonitor monitor) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            return false;
        }
        this.setSubTask(monitor, "Sending the install command to the device");
        Install install = new Install();
        if (packageID == null || packageID.isEmpty()) {
            Log.e(LOG_TAG, "Please, input package id");
            return false;
        }
        install.reinstallPackage(packageID, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
        if (install.getResponse().getStatusCode() == 0) {
            return true;
        }
        Log.e(LOG_TAG, "Install service in the device has failed");
        return false;
    }

    public boolean installPackageWithRDS(String packagePath, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.installPackageWithRDS(packagePath, null, receiver);
    }

    public boolean installPackageWithRDS(String packagePath, String packageID, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            return false;
        }
        Install install = new Install();
        if (packageID == null) {
            install.installPackageWithRDS(packagePath, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
        } else {
            install.installPackageWithRDS(packagePath, packageID, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
        }
        if (install.getResponse().getStatusCode() == 0) {
            return true;
        }
        Log.e(LOG_TAG, "Install service in the device has failed");
        return false;
    }

    public boolean unzipPackage(String packagePath, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.unzipPackage(packagePath, null, receiver);
    }

    public boolean unzipPackage(String packagePath, String packageID, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            return false;
        }
        Install install = new Install();
        if (packageID == null) {
            install.unzipPackage(packagePath, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
        } else {
            install.unzipPackage(packagePath, packageID, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
        }
        if (install.getResponse().getStatusCode() == 0) {
            return true;
        }
        Log.e(LOG_TAG, "unzip package service in the device has failed");
        return false;
    }

    public boolean extractTarPackage(String packagePath, String extractPath, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            return false;
        }
        Install install = new Install();
        install.extractTarPackage(packagePath, extractPath, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
        if (install.getResponse().getStatusCode() == 0) {
            return true;
        }
        Log.e(LOG_TAG, "deploy package service in the device has failed");
        return false;
    }

    public boolean uninstallPackage(String pkgID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.uninstallPackage(pkgID, null);
    }

    public boolean uninstallPackage(String pkgID, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && SmartDevelopmentBridge.getBridge().isTims()) {
            Uninstall uninstall = new Uninstall();
            uninstall.uninstallPackage(pkgID, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
            if (uninstall.getResponse().getStatusCode() == 0) {
                return true;
            }
            Log.e(LOG_TAG, "Uninstall service in the device has failed");
            return false;
        }
        boolean result = false;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String command = "uninstall:" + pkgID;
        appCmdReturn = this.runAppCmd(command, receiver);
        if (appCmdReturn.getAppCmdExitcode() == 0) {
            result = true;
        } else {
            Log.e(LOG_TAG, "Uninstall service in the device has failed.");
        }
        return result;
    }

    public org.tizen.sdblib.receiver.PackageInfo queryPackageInfo(String pkgID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        org.tizen.sdblib.receiver.PackageInfo pkgInfo = null;
        pkgInfo = this.getPackageInfoInternal(pkgID);
        return pkgInfo;
    }

    private org.tizen.sdblib.receiver.PackageInfo getPackageInfoInternal(String pkgID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            return this.getPackageInfoForPrev(pkgID);
        }
        PackageInfo pkgInfo = new PackageInfo();
        PackageItem info = pkgInfo.getPackageInformation(pkgID, this.device.getSerialNumber());
        if (info == null) {
            return null;
        }
        org.tizen.sdblib.receiver.PackageInfo packageInfo = null;
        if (pkgInfo.getResponse().getStatusCode() == 0) {
            String mainAppID = info.getMainAppID();
            PackageType pkgType = PackageType.getType(info.getType());
            boolean isRemovable = info.isRemovable();
            boolean isRunning = info.isRunning();
            packageInfo = new org.tizen.sdblib.receiver.PackageInfo(pkgID, mainAppID, pkgType, isRemovable, isRunning);
        } else {
            Log.e(LOG_TAG, "Package info service in the device has failed.");
        }
        return packageInfo;
    }

    private org.tizen.sdblib.receiver.PackageInfo getPackageInfoForPrev(String pkgID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String command = "packageinfo:" + pkgID;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String pkgInfoRawString = null;
        org.tizen.sdblib.receiver.PackageInfo pkgInfo = null;
        appCmdReturn = this.runAppCmd(command, null);
        if (appCmdReturn.getAppCmdExitcode() == 0 && appCmdReturn.getAppCmdReturnStr() != null) {
            pkgInfoRawString = appCmdReturn.getAppCmdReturnStr();
            String[] splittedWord = StringUtil.split(pkgInfoRawString, ":");
            if (splittedWord != null && splittedWord.length == 4) {
                String mainAppID = splittedWord[0];
                PackageType pkgType = PackageType.getType(splittedWord[1]);
                boolean isRemovable = Integer.parseInt(splittedWord[2]) == 1;
                boolean isRunning = Integer.parseInt(splittedWord[3]) == 1;
                pkgInfo = new org.tizen.sdblib.receiver.PackageInfo(pkgID, mainAppID, pkgType, isRemovable, isRunning);
            } else {
                Log.e(LOG_TAG, "Fail to parse package info.");
            }
        } else {
            Log.e(LOG_TAG, "Package info service in the device has failed.");
        }
        return pkgInfo;
    }

    public boolean runApplication(String appID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.runApplication(appID, null);
    }

    public boolean runApplication(String appID, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && SmartDevelopmentBridge.getBridge().isTims()) {
            Launch launch = new Launch();
            launch.runApplication(appID, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
            if (launch.getResponse().getStatusCode() == 0) {
                return true;
            }
            Log.e(LOG_TAG, "Run app service in the device has failed.");
            return false;
        }
        boolean result = false;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String command = "runapp:" + appID;
        appCmdReturn = this.runAppCmd(command, receiver);
        if (appCmdReturn.getAppCmdExitcode() == 0) {
            result = true;
        } else {
            Log.e(LOG_TAG, "Run app service in the device has failed.");
        }
        return result;
    }

    public boolean runUnitTestApplication(String appID, String usrArgs, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && SmartDevelopmentBridge.getBridge().isTims()) {
            Launch launch = new Launch();
            launch.runUnitTestApplication(appID, usrArgs, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
            if (launch.getResponse().getStatusCode() == 0) {
                return true;
            }
            Log.e(LOG_TAG, "Run unit test app service in the device has failed.");
            return false;
        }
        boolean result = false;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String command = "rununittestapp:" + appID + ":" + usrArgs;
        appCmdReturn = this.runAppCmd(command, receiver);
        if (appCmdReturn.getAppCmdExitcode() == 0) {
            result = true;
        } else {
            Log.e(LOG_TAG, "Run unit test service in the device has failed.");
        }
        return result;
    }

    public boolean killApplication(String appID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.killApplication(appID, null);
    }

    public boolean killApplication(String appID, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && SmartDevelopmentBridge.getBridge().isTims()) {
            Kill kill = new Kill();
            kill.killApplication(appID, this.device.getSerialNumber(), new NewSdbOutputReceiver(receiver));
            if (kill.getResponse().getStatusCode() == 0) {
                return true;
            }
            Log.e(LOG_TAG, "Kill app service in the device has failed");
            return false;
        }
        boolean result = false;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String command = "killapp:" + appID;
        appCmdReturn = this.runAppCmd(command, receiver);
        if (appCmdReturn.getAppCmdExitcode() == 0) {
            result = true;
        } else {
            Log.e(LOG_TAG, "kill app service in the device has failed.");
        }
        return result;
    }

    public boolean debugNativeApplication(int debugPort, String appID, int pID, String gdbServerPath) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && SmartDevelopmentBridge.getBridge().isTims()) {
            Launch launch = new Launch();
            launch.debugNativeApplication(appID, debugPort, pID, this.device.getSerialNumber(), null);
            if (launch.getResponse().getStatusCode() == 0) {
                return true;
            }
            Log.e(LOG_TAG, "debug native app service in the device has failed.");
            return false;
        }
        boolean result = false;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        int success_exit_code = 0;
        String command = "debugnativeapp:" + debugPort + ":" + appID + ":" + pID + ":" + gdbServerPath;
        appCmdReturn = this.runAppCmd(command, null);
        if (pID != -1) {
            success_exit_code = pID & 0xFF;
        }
        if (appCmdReturn.getAppCmdExitcode() == success_exit_code) {
            result = true;
        } else {
            Log.e(LOG_TAG, "debug native app service in the device has failed.");
        }
        return result;
    }

    public int debugWebApplication(String appID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && SmartDevelopmentBridge.getBridge().isTims()) {
            int port = -1;
            Launch launch = new Launch();
            port = launch.debugWebApplication(appID, this.device.getSerialNumber());
            if (launch.getResponse().getStatusCode() != 0) {
                Log.e(LOG_TAG, "debug web app service in the device has failed.");
            }
            return port;
        }
        int port = -1;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String command = "debugwebapp:" + appID;
        appCmdReturn = this.runAppCmd(command, null);
        if (appCmdReturn.getAppCmdExitcode() == 0 && appCmdReturn.getAppCmdReturnStr() != null) {
            port = Integer.parseInt(appCmdReturn.getAppCmdReturnStr());
        } else {
            Log.e(LOG_TAG, "debug web app service in the device has failed.");
        }
        return port;
    }

    public boolean isPlatformLog() throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        Dlog dlog = new Dlog();
        return dlog.isPlatformLogOn(this.device.getSerialNumber());
    }

    public void setPlatformLog(boolean logOn) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            return;
        }
        Dlog dlog = new Dlog();
        dlog.setPlatformLogOnOff(this.device.getSerialNumber(), logOn);
    }

    public void clearDlog() throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            return;
        }
        Dlog dlog = new Dlog();
        dlog.clear(this.device.getSerialNumber());
    }

    public void runDlog(String format, String filter, OutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            return;
        }
        Dlog dlog = new Dlog();
        dlog.run(this.device.getSerialNumber(), format, filter, null, 0, 0, receiver);
    }

    public void runDlog(String format, String filter, String filename, int count, int kbyte, OutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            return;
        }
        Dlog dlog = new Dlog();
        dlog.run(this.device.getSerialNumber(), format, filter, filename, count, kbyte, receiver);
    }

    private void setSubTask(IAppCmdProgressMonitor monitor, String name) {
        if (monitor != null) {
            monitor.startAppCmdSubTask(name);
        }
    }

    private AppCmdReceiver.AppCmdReturn runAppCmd(String command, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AppCmdReceiver appCmdReceiver = new AppCmdReceiver(receiver);
        CommandFactory.execute(command, "appcmd:").in((IDevice)this.device, appCmdReceiver);
        return appCmdReceiver.getAppCmdReturn();
    }

    private String transferPackage(String pkgfilePath, IAppCmdProgressMonitor monitor) throws IOException {
        SyncService sync = null;
        String remotePackageFilePath = null;
        this.setSubTask(monitor, "Querying the location where you want to copy the package file.");
        String destDir = this.getAppPackagePath();
        if (destDir == null) {
            Log.e(LOG_TAG, "Fail to get destination directory path for package install.");
            return null;
        }
        this.setSubTask(monitor, "Pushing the package file to the device.");
        sync = this.device.getSyncService();
        SyncResult syncResult = sync.push(new String[]{pkgfilePath}, this.device.getFileEntry(destDir), monitor);
        if (!syncResult.isOk()) {
            Log.e(LOG_TAG, "Fail to push package.");
            return null;
        }
        Log.d(LOG_TAG, "Success to push package.");
        remotePackageFilePath = String.valueOf(destDir) + Paths.get(pkgfilePath, new String[0]).getFileName().toString();
        return remotePackageFilePath;
    }

    private String queryAppInstallPath() throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String appInstallPath = null;
        String command = "appinstallpath:";
        appCmdReturn = this.runAppCmd(command, null);
        if (appCmdReturn.getAppCmdExitcode() == 0 && appCmdReturn.getAppCmdReturnStr() != null) {
            appInstallPath = appCmdReturn.getAppCmdReturnStr();
        } else {
            Log.e(LOG_TAG, "App install path service in the device has failed.");
        }
        return appInstallPath;
    }

    private String getAppPackagePath() throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (this.appPackagePath == null) {
            String appInstallPath = this.queryAppInstallPath();
            if (appInstallPath != null) {
                this.appPackagePath = String.valueOf(appInstallPath) + "/tmp/";
            } else {
                Log.e(LOG_TAG, "fail to get app install path.");
            }
        }
        return this.appPackagePath;
    }

    public static enum ApplicationType {
        WebApp{

            @Override
            protected String getStringName() {
                return ApplicationType.WEBAPP_TYPE_STR;
            }
        }
        ,
        CApp{

            @Override
            protected String getStringName() {
                return ApplicationType.CAPP_TYPE_STR;
            }
        }
        ,
        UnknownApp{

            @Override
            protected String getStringName() {
                return ApplicationType.UNKNOWNAPP_TYPE_STR;
            }
        };

        private static final String WEBAPP_TYPE_STR = "webapp";
        private static final String CAPP_TYPE_STR = "capp";
        private static final String UNKNOWNAPP_TYPE_STR = "unknown";

        protected abstract String getStringName();

        protected static ApplicationType getType(String strName) {
            if (strName.equals(WebApp.getStringName())) {
                return WebApp;
            }
            if (strName.equals(CApp.getStringName())) {
                return CApp;
            }
            return UnknownApp;
        }
    }

    public static enum PackageType {
        WebPkg{

            @Override
            protected String getStringName() {
                return PackageType.WEBAPP_TYPE_STR;
            }
        }
        ,
        NativePkg{

            @Override
            protected String getStringName() {
                return PackageType.NATIVEAPP_TYPE_STR;
            }
        }
        ,
        RPMPkg{

            @Override
            protected String getStringName() {
                return PackageType.RPM_TYPE_STR;
            }
        }
        ,
        UnknownPkg{

            @Override
            protected String getStringName() {
                return PackageType.UNKNOWNPKG_TYPE_STR;
            }
        };

        private static final String WEBAPP_TYPE_STR = "wgt";
        private static final String NATIVEAPP_TYPE_STR = "tpk";
        private static final String RPM_TYPE_STR = "rpm";
        private static final String UNKNOWNPKG_TYPE_STR = "unknown";

        protected abstract String getStringName();

        protected static PackageType getType(String strName) {
            if (strName.equals(WebPkg.getStringName())) {
                return WebPkg;
            }
            if (strName.equals(NativePkg.getStringName())) {
                return NativePkg;
            }
            if (strName.equals(RPMPkg.getStringName())) {
                return RPMPkg;
            }
            return UnknownPkg;
        }
    }
}

