/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringOptionHandler;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.sign.GenerateCertificateCommand;
import org.tizen.ncli.subcommands.sign.GenerateCertificateCommandData;
import org.tizen.ncli.util.ValidationResult;

@TizenSubCommand(name="certificate", usage="Generate a certificate for signing Tizen applications.")
public class GenerateCertificateCLI
extends AbstractCLI {
    @Option(name="-a", aliases={"--alias"}, required=true, metaVar="<alias name>", handler=StringOptionHandler.class, usage="Specify an alias name of the certificate (Required).")
    private String alias;
    @Option(name="-p", aliases={"--password"}, required=true, metaVar="<password>", handler=StringOptionHandler.class, usage="Specify the password of the certificate (Required).")
    private String password;
    @Option(name="-c", aliases={"--country"}, metaVar="<country code>", handler=StringOptionHandler.class, usage="Specify the user's country code, which consists of 2 letters.")
    private String country;
    @Option(name="-s", aliases={"--state"}, metaVar="<state>", handler=StringOptionHandler.class, usage="Specify the user's state.")
    private String state;
    @Option(name="-ct", aliases={"--city"}, metaVar="<city>", handler=StringOptionHandler.class, usage="Specify the user's city.")
    private String city;
    @Option(name="-o", aliases={"--organization"}, metaVar="<organization>", handler=StringOptionHandler.class, usage="Specify the user organization.")
    private String organization;
    @Option(name="-u", aliases={"--unit"}, metaVar="<unit>", handler=StringOptionHandler.class, usage="Specify the user's organization unit.")
    private String unit;
    @Option(name="-n", aliases={"--name"}, metaVar="<name>", handler=StringOptionHandler.class, usage="Specify the user name.")
    private String name;
    @Option(name="-e", aliases={"--email"}, metaVar="<email>", handler=StringOptionHandler.class, usage="Specify the user email.")
    private String email;
    @Option(name="-f", aliases={"--filename"}, metaVar="<filename>", handler=StringOptionHandler.class, usage="Specify the file name without a file extension. A certificate file is created with the file name. If you skip this option, the default file name, 'author', is used on creating the certificate file.")
    private String filename;

    @Override
    public int execute() {
        int result = -1;
        this.log.trace("Start certificate generation.");
        this.log.trace("[Argument] Alias: {}, Password: {}", (Object)this.alias, (Object)this.password);
        this.log.trace("[Argument] Filename: {}", (Object)this.filename);
        this.log.trace("[Argument] Country: {}", (Object)this.country);
        this.log.trace("[Argument] State: {}", (Object)this.state);
        this.log.trace("[Argument] City: {}", (Object)this.city);
        this.log.trace("[Argument] Organization: {}", (Object)this.organization);
        this.log.trace("[Argument] Organization Unit: {}", (Object)this.unit);
        this.log.trace("[Argument] Email: {}", (Object)this.email);
        this.log.trace("[Argument] Name: {}", (Object)this.name);
        this.checkDefaultWorkingDir();
        File cwdFile = this.getRealWorkingPath();
        this.progressLog.info("Working path: {}", (Object)this.getRealWorkingPath().getPath());
        if (!cwdFile.isDirectory()) {
            this.progressLog.error("No exist a specified working directory.");
            throw new UnexpectedException(2, "No exist a specified working directory.");
        }
        this.checkDefaultFilename();
        GenerateCertificateCommandData data = this.createData();
        boolean bValidated = data.validate(this.getRealWorkingPath());
        List<ValidationResult> resultList = data.getValidatedResult();
        if (this.hasValidationResultWith(ValidationResult.Status.ERROR, resultList)) {
            for (ValidationResult validationResult : resultList) {
                this.progressLog.error(validationResult.getMessage());
            }
            throw new UnexpectedException(2, "if have an error, halt.");
        }
        if (this.hasValidationResultWith(ValidationResult.Status.WARN, resultList)) {
            for (ValidationResult validationResult : resultList) {
                this.progressLog.warn(validationResult.getMessage());
            }
        }
        if (bValidated) {
            GenerateCertificateCommand command = new GenerateCertificateCommand(data);
            command.setWorkingDir(cwdFile);
            data = (GenerateCertificateCommandData)command.runCommand();
            if (data != null) {
                result = 0;
            }
        }
        this.log.trace("Finish certificate generation.");
        return result;
    }

    private boolean hasValidationResultWith(ValidationResult.Status status, List<ValidationResult> resultList) {
        for (ValidationResult result : resultList) {
            if (!status.equals((Object)result.getStatus())) continue;
            return true;
        }
        return false;
    }

    protected void checkDefaultWorkingDir() {
        if (this.workingDir == null) {
            String userDataPath = InstallPathConfig.getUserDataPath();
            this.workingDir = new File(new File(userDataPath, "keystore"), "author");
            this.progressLog.warn("No path option. Will be generated on '{}'.", (Object)this.workingDir);
            if (!this.workingDir.isDirectory()) {
                if (this.workingDir.mkdirs()) {
                    this.progressLog.info("Created the working directory.");
                } else {
                    this.progressLog.warn("Cannot create the working directory.");
                }
            }
        }
        this.log.trace("Current working directory: {}", (Object)this.workingDir);
    }

    protected void checkDefaultFilename() {
        if (this.filename == null) {
            this.filename = "author";
            this.progressLog.warn("No filename option. Default filename like '{}' is used.", (Object)this.filename);
        }
    }

    protected GenerateCertificateCommandData createData() {
        GenerateCertificateCommandData data = new GenerateCertificateCommandData(this.filename, this.password, this.alias, this.password);
        data.setCity(this.city);
        data.setCountry(this.country);
        data.setEmail(this.email);
        data.setName(this.name);
        data.setOrganization(this.organization);
        data.setUnit(this.unit);
        data.setState(this.state);
        return data;
    }
}

