/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.util;

import java.io.IOException;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.app.process.DeviceProcessList;
import org.tizen.sdblib.app.process.ProcessInfo;
import org.tizen.sdblib.util.PidReceiver;
import org.tizen.sdblib.util.StringUtil;

public class ApplicationUtil {
    public static int getPid(IDevice device, String pkgID, String binaryName) throws IOException {
        boolean canUseRoot;
        int pid = ApplicationUtil.getPidWidthApp2Pid(device, pkgID);
        if (pid != -1) {
            return pid;
        }
        boolean bl = canUseRoot = !device.isSupportCapability() || "disabled".equals(device.getPlatformCapability().getAppid2pidSupport());
        if (canUseRoot) {
            return ApplicationUtil.getPidWithProcessList(device, pkgID, binaryName);
        }
        return ApplicationUtil.getPidWidthApp2Pid(device, pkgID);
    }

    public static int getPidWithProcessList(IDevice device, String pkgID, String binaryName) {
        DeviceProcessList processList = new DeviceProcessList(device, String.valueOf(device.getAppInstallPath()) + "/" + pkgID);
        ProcessInfo[] pInfos = processList.getProcessList();
        ProcessInfo pInfo = null;
        ProcessInfo[] processInfoArray = pInfos;
        int n = pInfos.length;
        int n2 = 0;
        while (n2 < n) {
            String infoBinaryName;
            ProcessInfo info = processInfoArray[n2];
            String infoName = info.getName();
            if (infoName.contains(pkgID) && (infoBinaryName = StringUtil.getLastStringAfter(infoName, "/")) != null && infoBinaryName.equals(binaryName)) {
                pInfo = info;
                break;
            }
            ++n2;
        }
        if (pInfo != null) {
            return pInfo.getPid();
        }
        return -1;
    }

    public static int getPidWidthApp2Pid(IDevice device, String pkgID) throws IOException {
        PidReceiver receiver = new PidReceiver();
        String command = String.format("/usr/bin/appid2pid %s", pkgID);
        device.executeShellCommand(command, receiver);
        return receiver.getPid();
    }
}

