/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sdb.command;

import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.sdb.command.ApplicationCommand;
import org.tizen.common.sdb.command.SdbCommandHelper;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.receiver.PackageInfo;
import org.tizen.sdblib.service.ApplicationCmdService;

public class PackageInfoCommand
extends ApplicationCommand {
    public static final String CHECK_ROMOVABLE_COMMAND = "pkginfo --pkg %s | grep -i Removable";
    public static final String CHECK_INSTALLED_COMMAND = "pkgcmd -l | grep %s --word-regexp";
    public static final String GET_PACKAGE_ID_COMMAND = "pkginfo --app %s | grep %s";
    public static final String IS_RUNNING_COMMAND = "pkgcmd -C -n %s";
    private String command = "";

    public PackageInfoCommand(IDevice device, ITizenConsoleManager console) {
        super(device, console);
    }

    public boolean isRemovable(String pkgId) throws Exception {
        String[] lines;
        if (ApplicationCommand.isAppCmdSupported(this.getDevice())) {
            ApplicationCmdService appcmd = this.getApplicationCmdService();
            PackageInfo pkgInfo = appcmd.queryPackageInfo(pkgId);
            if (pkgInfo == null) {
                return false;
            }
            return pkgInfo.getIsRemovable();
        }
        this.command = String.format(CHECK_ROMOVABLE_COMMAND, pkgId);
        this.executeCommand();
        String[] stringArray = lines = this.helper.getResultLineStrings();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (TizenPlatformConstants.ROAPP_RESULT.equals(line)) {
                return false;
            }
            if (TizenPlatformConstants.RWAPP_RESULT.equals(line)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isInstalled(String pkgId, String pkgType) throws Exception {
        if (ApplicationCommand.isAppCmdSupported(this.getDevice())) {
            ApplicationCmdService appcmd = this.getApplicationCmdService();
            PackageInfo pkgInfo = appcmd.queryPackageInfo(pkgId);
            if (pkgInfo != null) {
                return true;
            }
        } else {
            this.command = String.format(CHECK_INSTALLED_COMMAND, pkgId);
            this.executeCommand();
            String endLine = this.helper.getEndLine();
            if (endLine != null && !endLine.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public String getPkgId(String appId) throws Exception {
        String packageStr = "Package: ";
        this.command = String.format(GET_PACKAGE_ID_COMMAND, appId, packageStr);
        this.executeCommand();
        String[] lines = this.helper.getResultLineStrings();
        String pkgId = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(packageStr)) {
                pkgId = line.substring(packageStr.length());
                break;
            }
            ++n2;
        }
        return pkgId;
    }

    public boolean isRunning(String pkgId) throws Exception {
        String[] lines;
        String isRunningStr = "is Running";
        this.command = String.format(IS_RUNNING_COMMAND, pkgId);
        this.executeCommand();
        boolean result = false;
        String[] stringArray = lines = this.helper.getResultLineStrings();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.endsWith(isRunningStr)) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    @Override
    protected void executeCommand() throws Exception {
        this.helper = new SdbCommandHelper(this.getDevice(), this.getConsole(), null);
        this.helper.runCommand(this.getCommand());
    }

    protected String getCommand() {
        return this.command;
    }
}

