/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import java.io.IOException;
import org.kohsuke.args4j.Option;
import org.tizen.common.project.util.ProjectValidationUtil;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.createcsharp.CreateCSProjectCommand;
import org.tizen.ncli.subcommands.createcsharp.CreateCSProjectCommandData;

@TizenSubCommand(name="cs-project", usage="Create the tizen C# project.")
public class CreateCSProjectCLI
extends AbstractCLI {
    @Option(name="-t", aliases={"--template"}, required=true, metaVar="<template name>", usage="Specify the template name (Required).")
    private String templateName;
    @Option(name="-n", aliases={"--name"}, required=true, metaVar="<project name>", usage="Specify the project name (Required).")
    private String projectName;
    private static final String PACKAGE_NAME_PATTERN = "^[a-zA-Z][a-zA-Z0-9-\\._]{2,49}(?<![\\._\\-])$";

    @Override
    public int execute() {
        int result = -1;
        CreateCSProjectCommand csCommand = new CreateCSProjectCommand();
        CreateCSProjectCommandData data = csCommand.getData();
        if (this.templateName != null) {
            data.setTemplateName(this.templateName);
        }
        if (this.projectName != null) {
            boolean ret = this.IsValidProjectName();
            if (!ret) {
                this.log.error("invalid project name.");
                return 2;
            }
            data.setProjectName(this.projectName);
        }
        try {
            data.setOutputName(this.getRealWorkingPath().getCanonicalPath() + File.separatorChar + data.getProjectName());
            CreateCSProjectCommandData finalData = (CreateCSProjectCommandData)csCommand.runCommand();
            if (finalData != null) {
                this.progressLog.info("Project Location: {}", (Object)finalData.getOutputName());
                result = 0;
            }
        }
        catch (IOException e) {
            this.log.error(TizenCLIMessages.CR_CANNOT_CREATE_OUTDIR);
            throw new UnexpectedException(2, TizenCLIMessages.CR_CANNOT_CREATE_OUTDIR);
        }
        catch (UnexpectedException e) {
            throw e;
        }
        return result;
    }

    private boolean IsValidProjectName() {
        if (!ProjectValidationUtil.isValidNameLength((String)this.projectName)) {
            this.progressLog.error("Error in project naming rule : The project name must be longer than 2 characters");
            return false;
        }
        if (!ProjectValidationUtil.isValidName((String)this.projectName)) {
            this.progressLog.error("Error in roject naming rule : Invalid character used in the project name");
            return false;
        }
        if (!this.projectName.matches(PACKAGE_NAME_PATTERN)) {
            this.progressLog.error("Error in package naming rule : The package name must start with an alphabetical character and can only contain letters or numbers.");
            return false;
        }
        return true;
    }
}

