/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.application;

import org.tizen.common.util.Assert;

public class Version
implements Comparable<Version> {
    public static final String REGEXP = "[0-9]+(\\.[0-9]+)+";
    public static final String DELIMETER_REGEXP = "\\.";
    private String version;
    public static final Version ZERO = new Version("0.0");
    public static final Version VERSION_3 = new Version("3.0");
    public static final Version VERSION_4 = new Version("4.0");

    public Version(String version) {
        Assert.notNull(version, "Version can not be null");
        Assert.isTrue(version.matches(REGEXP), "Invalid version format");
        this.version = version;
    }

    public final String get() {
        return this.version;
    }

    @Override
    public int compareTo(Version ver) {
        if (ver == null) {
            return 1;
        }
        String[] thisParts = this.get().split(DELIMETER_REGEXP);
        String[] thatParts = ver.get().split(DELIMETER_REGEXP);
        int length = Math.max(thisParts.length, thatParts.length);
        int i = 0;
        while (i < length) {
            int thatPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart > thatPart) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.compareTo((Version)obj) == 0;
    }

    public boolean isSameOrBiggerThanVersion3() {
        return this.compareTo(VERSION_3) >= 0;
    }

    public boolean isSameOrBiggerThanVersion4() {
        return this.compareTo(VERSION_4) >= 0;
    }
}

