/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.realm;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.MapUtil;
import org.tizen.common.verrari.Template;
import org.tizen.common.verrari.TemplateException;
import org.tizen.common.verrari.realm.CommonRealm;
import org.tizen.common.verrari.realm.Query;
import org.tizen.common.verrari.template.DirectoryTemplate;

public class DirectoryRealm
extends CommonRealm {
    @Override
    public Template getTemplate(String id) throws IOException {
        Template template;
        Query templateQuery = this.getTemplateQuery(this);
        Map modelMap = MapUtil.asMap((Object[][])new Object[][]{{"id", id}});
        this.logger.trace("Map :{}", (Object)modelMap);
        String query = templateQuery.query(modelMap);
        this.logger.trace("Query :{}", (Object)query);
        URL url = new URL(query);
        File file = null;
        try {
            file = this.getURItoFile(url.toURI());
            template = this.getTemplate(file);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                throw new IOException("Template[" + id + "] not found");
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{file});
                throw throwable;
            }
        }
        IOUtil.tryClose((Object[])new Object[]{file});
        return template;
    }

    public Template getTemplate(File file) throws IOException {
        try {
            DirectoryTemplate template = new DirectoryTemplate(file);
            return template;
        }
        catch (TemplateException e) {
            throw new IOException(e);
        }
    }

    protected File getURItoFile(URI uri) {
        return new File(uri);
    }
}

