/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.kohsuke.args4j.Argument;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@TizenSubCommand(name="manual", usage="Show the description of a given command.")
public class ManualCLI
extends AbstractCLI {
    @Argument(index=0, metaVar="<command>")
    String commandName = "main";
    private static final String DIR_MANUAL = "tools" + File.separator + "ide" + File.separator + "resources" + File.separator + "doc" + File.separator + "manual";

    public ManualCLI() {
        this.isLoggingStartFinish = false;
    }

    @Override
    public int execute() {
        try {
            String sdkPath = InstallPathConfig.getSDKPath();
            if (sdkPath == null) {
                this.log.debug("Cannot get SDKPath");
                this.progressLog.error("Error : Cannot get SDKPath to display manual.");
                return -1;
            }
            File file = new File(sdkPath + File.separator + DIR_MANUAL + File.separator + this.commandName + ".xml");
            if (!file.exists()) {
                this.log.debug("The manual file for " + this.commandName + " command is not exist.");
                this.progressLog.error("Error : The manual file for " + this.commandName + " command is not exist.");
                return -2;
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nodes = doc.getElementsByTagName(this.commandName);
            if (nodes.getLength() <= 0) {
                this.log.debug("The manual data for " + this.commandName + " command is not exist.");
                this.progressLog.error("Error : The manual data for " + this.commandName + " command is not exist.");
                return -3;
            }
            NodeList childNodes = nodes.item(0).getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                if (childNodes.item(i).getNodeType() != 4) continue;
                this.progressLog.error(childNodes.item(i).getNodeValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }
}

