/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.file.FileHandler;
import org.tizen.common.util.Assert;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.io.BufferInputStream;
import org.tizen.common.util.io.BufferOutputStream;
import org.tizen.common.verrari.Storage;
import org.tizen.common.verrari.util.BufferFactory;

public class FileStorage
implements Storage {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected FileHandler handler = null;

    public FileStorage(FileHandler handler) {
        Assert.notNull((Object)handler);
        this.handler = handler;
    }

    @Override
    public OutputStream getTarget(final String key) throws IOException {
        this.logger.trace("Target :{}", (Object)key);
        BufferOutputStream bufferOut = new BufferOutputStream(BufferFactory.getInstance().create()){

            public void close() throws IOException {
                String directory = FilenameUtil.removeTailingPath((String)key, (int)1);
                FileStorage.this.logger.trace("Make directory :{}", (Object)directory);
                if (!StringUtil.isEmpty((CharSequence)directory)) {
                    FileStorage.this.handler.makeDirectory(directory);
                }
                FileStorage.this.handler.write(key, (InputStream)new BufferInputStream(this.buffer));
                super.close();
            }
        };
        return bufferOut;
    }

    @Override
    public InputStream getSource(String key) throws IOException {
        this.logger.trace("Source :{}", (Object)key);
        return this.handler.read(key);
    }
}

