/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Selector;
import org.tizen.sdblib.service.ISyncProgressMonitor;
import org.tizen.sdblib.util.Log;

public class IOUtil {
    private static final int BUFFER_SIZE = 8192;

    public static void tryClose(Closeable obj) {
        if (obj == null) {
            return;
        }
        try {
            obj.close();
        }
        catch (IOException e) {
            Log.e("sdb", "failed to close :" + e);
        }
    }

    public static void tryClose(Object ... closeables) {
        if (closeables == null) {
            return;
        }
        Object[] objectArray = closeables;
        int n = closeables.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null) {
                try {
                    if (obj instanceof Closeable) {
                        ((Closeable)obj).close();
                    } else if (obj instanceof Selector) {
                        ((Selector)obj).close();
                    } else if (obj instanceof Socket) {
                        ((Socket)obj).close();
                    } else if (obj instanceof ServerSocket) {
                        ((ServerSocket)obj).close();
                    }
                }
                catch (IOException iOException) {
                    Log.w("util", "close failed :" + obj);
                }
            }
            ++n2;
        }
    }

    public static void tryFlush(Flushable ... flushables) {
        if (flushables == null) {
            return;
        }
        Flushable[] flushableArray = flushables;
        int n = flushables.length;
        int n2 = 0;
        while (n2 < n) {
            Flushable flushable = flushableArray[n2];
            if (flushable != null) {
                try {
                    flushable.flush();
                }
                catch (IOException iOException) {
                    Log.w("util", "Fail to flush " + flushable);
                }
            }
            ++n2;
        }
    }

    public static void redirect(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int nRead = 0;
        while ((nRead = in.read(buffer)) > 0) {
            out.write(buffer, 0, nRead);
        }
        IOUtil.tryFlush(out);
    }

    public static void redirect(InputStream in, OutputStream out, ISyncProgressMonitor monitor) throws IOException {
        byte[] buffer = new byte[8192];
        int nRead = 0;
        while ((nRead = in.read(buffer)) > 0) {
            out.write(buffer, 0, nRead);
            monitor.advance(nRead);
        }
        IOUtil.tryFlush(out);
    }

    public static void redirect(Reader reader, Writer writer) throws IOException {
        char[] buffer = new char[8192];
        int nRead = 0;
        while ((nRead = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, nRead);
        }
        IOUtil.tryFlush(writer);
    }

    public static void redirect(Reader reader, StringBuffer writer) throws IOException {
        char[] buffer = new char[8192];
        int nRead = 0;
        while ((nRead = reader.read(buffer)) > 0) {
            writer.append(buffer, 0, nRead);
        }
    }

    public static void redirect(Reader reader, StringBuilder writer) throws IOException {
        if (reader == null) {
            return;
        }
        char[] buffer = new char[8192];
        int nRead = 0;
        while ((nRead = reader.read(buffer)) > 0) {
            writer.append(buffer, 0, nRead);
        }
    }

    public static byte[] getBytes(InputStream in) throws IOException {
        return IOUtil.getBytes(in, false);
    }

    public static byte[] getBytes(InputStream in, boolean bClose) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            IOUtil.redirect(in, byteOut);
            if (bClose) {
                IOUtil.tryClose(in);
            }
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
        finally {
            IOUtil.tryClose(byteOut);
        }
    }

    public static String getString(Reader reader) throws IOException {
        return IOUtil.getString(reader, false);
    }

    public static String getString(Reader reader, boolean bClose) throws IOException {
        String string;
        StringBuilder writer = new StringBuilder();
        try {
            IOUtil.redirect(reader, writer);
            if (bClose) {
                IOUtil.tryClose(reader);
            }
            string = writer.toString();
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(writer);
            throw throwable;
        }
        IOUtil.tryClose(writer);
        return string;
    }

    public static String getString(InputStream in) throws IOException {
        return IOUtil.getString(new InputStreamReader(in));
    }

    public static String getString(InputStream in, boolean bClose) throws IOException {
        return IOUtil.getString(new InputStreamReader(in), bClose);
    }
}

