/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.target.Run;
import org.tizen.ncli.subcommands.target.RunCLICommand;

@TizenSubCommand(name="run", usage="Run the application on the target device.")
public class RunCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-t", aliases={"--target"}, metaVar="<target>", usage="Specify the target name to run the package.")
    private String target;
    @Option(name="-s", aliases={"--serial"}, metaVar="<serial>", usage="Specify the serial to run the package.")
    private String serial;
    @Option(name="-p", aliases={"--pkgid"}, required=true, metaVar="<package id>", usage="Specify the Tizen package ID installed on the target.")
    private String pkgid;
    @Option(name="-T", aliases={"--type"}, metaVar="package type (app or utc)", usage="Specify if the package is app or native unit test")
    private String type;
    @Option(name="-o", aliases={"--out"}, metaVar="Output folder to copy unit test and coverage files", usage="Specify the output folder to copy unit test and coverage artifacts")
    private String outFolder;

    @Override
    public int execute() {
        int result = -1;
        this.log.trace("Execute RunCLI...");
        RunCLICommand command = new RunCLICommand();
        command.setWorkingDir(this.getRealWorkingPath());
        if (this.serial != null) {
            command.setTarget(this.serial);
        } else {
            command.setTargetByName(this.target);
        }
        if (this.type == null) {
            command.setPkgType("app");
        } else {
            command.setPkgType(this.type);
        }
        command.setOutputFolder(this.outFolder);
        command.setPackageId(this.pkgid);
        Run data = (Run)command.runCommand();
        if (data != null) {
            result = 0;
        }
        return result;
    }
}

