/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util;

import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tizen.library.sdkutils.util.EmptyLogger;
import org.tizen.library.sdkutils.util.PathUtil;
import org.tizen.library.sdkutils.util.SDKInfoUtil;

public class Log {
    public static final String LOG_INDENT_TRACE = "\t";
    private static final Date startTime = new Date();
    private static Logger LOGGER = null;
    private static Logger INFO_LOGGER = null;

    public static synchronized boolean open() {
        return Log.open("sdkUtilsLogFileName", "sdk-utils_");
    }

    public static synchronized boolean open(String name, String head) {
        boolean result = false;
        Log.removeTooOldLogs(head);
        String logDirPath = Log.getLogDirectoryPath();
        if (logDirPath != null && !logDirPath.isEmpty()) {
            String path = PathUtil.getPath(logDirPath, "sdk-utils-log", head + new SimpleDateFormat("yyyyMMdd-HHmmssSSS").format(startTime) + ".log");
            System.setProperty(name, path);
            LOGGER = LogManager.getLogger((String)Log.class.getName());
            INFO_LOGGER = LogManager.getLogger((String)"infoLoger");
            result = true;
        }
        return result;
    }

    private static void removeTooOldLogs(final String head) {
        String logDirPath = Log.getLogDirectoryPath();
        if (logDirPath != null && !logDirPath.isEmpty()) {
            File confDir = new File(PathUtil.getPath(logDirPath, "sdk-utils-log"));
            File[] logs = confDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().matches(head + "[0-9]{8}-[0-9]{9,}.log");
                }
            });
            if (logs == null) {
                return;
            }
            Arrays.sort(logs, new Comparator<File>(){

                @Override
                public int compare(File arg0, File arg1) {
                    return arg0.compareTo(arg1);
                }
            });
            for (int i = 0; i < logs.length - 20; ++i) {
                if (logs[i].delete() || LOGGER == null) continue;
                LOGGER.error("Fail to delete file ==> " + logs[i]);
            }
        }
    }

    private static String getLogDirectoryPath() {
        String retPath = SDKInfoUtil.findSDKDataPath(Log.class);
        return retPath;
    }

    public static void logTitle(String msg) {
        if (INFO_LOGGER != null) {
            INFO_LOGGER.info("**********************  " + msg + "  **********************");
        }
    }

    public static void info(String msg) {
        if (INFO_LOGGER != null) {
            INFO_LOGGER.info(msg);
        }
    }

    public static void trace(String msg) {
        if (INFO_LOGGER != null) {
            INFO_LOGGER.trace(msg);
        }
    }

    public static void debug(String msg) {
        if (INFO_LOGGER != null) {
            INFO_LOGGER.debug(msg);
        }
    }

    public static void error(String msg) {
        if (INFO_LOGGER != null) {
            INFO_LOGGER.error(msg);
        }
    }

    public static void catching(Throwable arg) {
        if (INFO_LOGGER != null) {
            INFO_LOGGER.catching(arg);
        }
    }

    public static void throwing(Throwable arg) {
        if (INFO_LOGGER != null) {
            INFO_LOGGER.throwing(arg);
        }
    }

    public static Logger getLogger(Class<?> object) {
        EmptyLogger retLogger = null;
        if (LOGGER == null) {
            Log.open();
        }
        retLogger = LOGGER == null ? new EmptyLogger() : LogManager.getLogger((String)object.getName());
        return retLogger;
    }
}

