/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.util;

import java.io.IOException;
import org.tizen.sdblib.DeviceState;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.tizen.sdblib.util.FilenameUtil;
import org.tizen.sdblib.util.Log;

public class DeviceUtil {
    public static boolean isOnline(IDevice device) {
        if (device == null) {
            return false;
        }
        return DeviceState.ONLINE.equals((Object)device.getState());
    }

    public static boolean isUnknownDevice(IDevice device) {
        if (device == null) {
            return true;
        }
        return DeviceState.UNKNOWN.equals((Object)device.getState());
    }

    public static String uploadPackage(String localPath, IDevice device) throws IOException {
        try {
            String filename = FilenameUtil.getFilename(localPath);
            String remoteFilePath = FilenameUtil.addTailingPath("/tmp", filename);
            Log.d("device", String.format("Uploading %1$s onto device '%2$s'", filename, device.getSerialNumber()));
            SyncService sync = device.getSyncService();
            if (sync == null) {
                throw new IOException("Unable to open sync connection!");
            }
            SyncResult result = sync.push(localPath, device.getFileEntry(remoteFilePath));
            if (!result.isOk()) {
                throw new IOException(String.format("Unable to upload file: %1$s", result.getMessage()));
            }
            return remoteFilePath;
        }
        catch (TimeoutException e) {
            Log.e("device", "Unable to open sync connection! Timeout.");
            throw e;
        }
        catch (IOException e) {
            Log.e("device", String.format("Unable to open sync connection! reason: %1$s", e.getMessage()));
            throw e;
        }
    }
}

