/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.realm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.verrari.Realm;
import org.tizen.common.verrari.Template;

public class CompositeRealm
implements Realm {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ArrayList<Realm> chain = new ArrayList();

    public void addRealm(Realm realm) {
        this.chain.add(realm);
    }

    public Realm[] getRealm() {
        if (this.chain.isEmpty()) {
            return null;
        }
        return this.chain.toArray(new Realm[0]);
    }

    @Override
    public Collection<String> getAttributeKeys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttribute(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Template getTemplate(String id) throws IOException {
        for (Realm realm : this.chain) {
            try {
                Template template = realm.getTemplate(id);
                if (template == null) continue;
                return template;
            }
            catch (IOException e) {
                this.logger.debug("Realm : {} in {} ", (Object)realm, (Object)e.getMessage());
            }
        }
        return null;
    }
}

