/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.config;

import java.io.File;
import java.util.Properties;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.OSChecker;

public class ConfigConstant {
    public static final String CONFIG_FILE_VERSION = "1.2";
    public static final String KEY = "";
    public static final String REALM = "pic.template.realm";
    public static final String CLI_HOME = System.getenv("CLI_HOME");
    public static final String REALM_HOME = CLI_HOME + File.separator + "realm";
    public static final String WEB_REALM_URL = "file:///" + REALM_HOME + File.separator + "ncli-web-config.json";
    public static final String DEFAULT_BUILD_ARCHITECTURE = "default.build.architecture";
    public static final String DEFAULT_BUILD_COMPILER = "default.build.compiler";
    public static final String DEFAULT_BUILD_CONFIGURATION = "default.build.configuration";
    public static final String DEFAULT_SDB_TIMEOUT = "default.sdb.timeout";
    public static final String DEFAULT_PROFILES_PATH = "default.profiles.path";
    public static final String DEFAULT_CSHARP_BUILDTOOL_PATH = "default.csharp.buildtool.path";
    public static final String DEFAULT_DOTNET_TOOL_PATH = "default.dotnet.tool.path";
    public static final String DEFAULT_CSHARP_TOOLCHAIN = "default.csharp.toolchain";
    public static final String PROFILES_PATH = "profiles.path";
    public static final int CLI_ENV_PREFIX_LENGTH = 4;
    public static final String CLI_ENV_PREFIX = "env.";
    private static final String DEFAULT_BUILD_ARCHITECTURE_VALUE = "x86";
    private static final String DEFAULT_BUILD_COMPILER_VALUE = "llvm";
    private static final String DEFAULT_BUILD_CONFIGURATION_VALUE = "Debug";
    private static final String DEFAULT_SDB_TIMEOUT_VALUE = "60000";
    private static final String DEFAULT_PROFILES_PATH_VALUE = "";
    private static final String DEFAULT_CSHARP_BUILDTOOL_PATH_VALUE = "C:/Program Files (x86)/Microsoft Visual Studio/2017/Professional/MSBuild/15.0/Bin/MSBuild.exe";
    private static final String DEFAULT_DOTNET_TOOL_PATH_WINDOWS = "C:/Program Files/dotnet/dotnet.exe";
    private static final String DEFAULT_DOTNET_TOOL_PATH_LINUX = "/usr/bin/dotnet";
    private static final String DEFAULT_DOTNET_TOOL_PATH_MAC = "/usr/local/share/dotnet/dotnet";
    private static final String DEFAULT_CSHARP_TOOLCHAIN_VALUE = "dotnet-cli";
    public static final Properties DEFAULT_CONFIGURATION_KEY_VALUE = ConfigConstant.getDefaultValues();

    public static Properties getDefaultValues() {
        Properties prop = new Properties();
        prop.setProperty(DEFAULT_BUILD_ARCHITECTURE, DEFAULT_BUILD_ARCHITECTURE_VALUE);
        prop.setProperty(DEFAULT_BUILD_COMPILER, DEFAULT_BUILD_COMPILER_VALUE);
        prop.setProperty(DEFAULT_BUILD_CONFIGURATION, DEFAULT_BUILD_CONFIGURATION_VALUE);
        prop.setProperty(DEFAULT_SDB_TIMEOUT, DEFAULT_SDB_TIMEOUT_VALUE);
        String sdkDataPath = InstallPathConfig.getUserDataPath();
        if (sdkDataPath == null) {
            prop.setProperty(DEFAULT_PROFILES_PATH, "");
        } else {
            String defaultProfilesPath = sdkDataPath + File.separator + "profile" + File.separator + "profiles.xml";
            prop.setProperty(DEFAULT_PROFILES_PATH, defaultProfilesPath);
        }
        prop.setProperty(DEFAULT_CSHARP_BUILDTOOL_PATH, DEFAULT_CSHARP_BUILDTOOL_PATH_VALUE);
        if (OSChecker.isWindows()) {
            prop.setProperty(DEFAULT_DOTNET_TOOL_PATH, DEFAULT_DOTNET_TOOL_PATH_WINDOWS);
        } else if (OSChecker.isLinux()) {
            prop.setProperty(DEFAULT_DOTNET_TOOL_PATH, DEFAULT_DOTNET_TOOL_PATH_LINUX);
        } else {
            prop.setProperty(DEFAULT_DOTNET_TOOL_PATH, DEFAULT_DOTNET_TOOL_PATH_MAC);
        }
        prop.setProperty(DEFAULT_CSHARP_TOOLCHAIN, DEFAULT_CSHARP_TOOLCHAIN_VALUE);
        return prop;
    }
}

