/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.template;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.file.Filter;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.common.verrari.ITemplate;
import org.tizen.common.verrari.ITemplateProvider;
import org.tizen.common.verrari.Storage;
import org.tizen.common.verrari.TemplateException;
import org.tizen.common.verrari.engine.TemplateEngineFactory;
import org.tizen.common.verrari.exception.UnsupportedVersionException;
import org.tizen.common.verrari.realm.JarRealm;
import org.tizen.common.verrari.template.CommonTemplate;
import org.tizen.common.verrari.template.InMemoryTemplate;
import org.tizen.common.verrari.template.TemplateManager;
import org.tizen.common.verrari.util.BufferFactory;

public class StandardTemplate
extends CommonTemplate {
    public StandardTemplate(byte[] bytes) throws IOException, TemplateException {
        ByteArrayInputStream byteArrayInputStream = null;
        JarInputStream jarInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(bytes);
            jarInputStream = new JarInputStream(byteArrayInputStream);
            this.preload(jarInputStream);
            this.load(jarInputStream);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{jarInputStream, byteArrayInputStream});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{jarInputStream, byteArrayInputStream});
    }

    protected void preload(JarInputStream jarIn) throws IOException, TemplateException {
        Manifest mf = jarIn.getManifest();
        if (mf != null) {
            Attributes attributes = mf.getMainAttributes();
            for (Object key : attributes.keySet()) {
                Attributes.Name name = (Attributes.Name)key;
                this.attrs.put(name.toString(), attributes.getValue(name));
            }
        }
        JarEntry iter = null;
        while ((iter = jarIn.getNextJarEntry()) != null) {
            if (iter.isDirectory()) continue;
            String name = iter.getName();
            if ("META-INF/MANIFEST.MF".equals(name)) {
                this.loadAttribute(jarIn);
            }
            if ("META-INF/messages.properties".equals(name)) {
                this.defaultBundle = new PropertyResourceBundle(jarIn);
                continue;
            }
            if (!name.startsWith("META-INF/messages_") || !name.endsWith(".properties")) continue;
            String localeStr = name.substring("META-INF/messages_".length(), name.length() - ".properties".length());
            Object[] fragments = StringUtil.split((String)localeStr, (String)"_");
            String lang = (String)ArrayUtil.pickupFirst((Object[])fragments);
            String country = 2 == fragments.length ? fragments[1] : "";
            Locale locale = new Locale(lang, country);
            PropertyResourceBundle bundle = new PropertyResourceBundle(jarIn);
            this.bundles.put(locale, bundle);
        }
        String version = (String)this.attrs.get("Tizen-Template-Version");
        this.checkVersion(version);
    }

    protected void load(JarInputStream in) throws TemplateException, IOException {
        this.engine = TemplateEngineFactory.getInstance().create();
        TemplateManager templates = new TemplateManager();
        String excludes = (String)this.attrs.get("Tizen-Template-Exclude");
        String includes = (String)this.attrs.get("Tizen-Template-Include");
        String copies = (String)this.attrs.get("Tizen-Template-Copy");
        String mappings = (String)this.attrs.get("Tizen-Template-Mapping");
        this.mapper = this.getMapper((String)this.attrs.get("Tizen-Template-Mapper"), mappings);
        Filter filter = this.createFilter(JarRealm.separate(includes), JarRealm.separate(excludes));
        Filter copyFilter = this.createFilter(JarRealm.separate(copies), null);
        JarEntry iter = null;
        while ((iter = in.getNextJarEntry()) != null) {
            byte[] contents;
            String name;
            block6: {
                block5: {
                    if (iter.isDirectory()) continue;
                    name = iter.getName();
                    this.logger.trace("Name :{}", (Object)name);
                    contents = null;
                    try {
                        contents = IOUtil.getBytes((InputStream)in);
                        templates.addTemplate(name, (ITemplate)new InMemoryTemplate(contents, "utf-8", (FactoryWithArgument)BufferFactory.getInstance()));
                        if (!copyFilter.accept("/", name)) break block5;
                        this.logger.debug("{} is copy target", (Object)name);
                        this.copyNames.add(name);
                    }
                    catch (Throwable throwable) {
                        IOUtil.tryClose((Object[])new Object[]{contents});
                        throw throwable;
                    }
                    IOUtil.tryClose((Object[])new Object[]{contents});
                    continue;
                }
                if (filter.accept("/", name)) break block6;
                this.logger.info("{} filtered", (Object)name);
                IOUtil.tryClose((Object[])new Object[]{contents});
                continue;
            }
            this.templateNames.add(name);
            IOUtil.tryClose((Object[])new Object[]{contents});
        }
        this.engine.setTemplateProvider((ITemplateProvider)templates);
    }

    @Override
    public void template(IModelProvider models, Storage storage) throws TemplateException {
        this.logger.info("Start template process...");
        context.set(this);
        try {
            try {
                String target;
                ITemplateProvider provider = this.engine.getTemplateProvider();
                if (provider != null) {
                    for (String name : this.copyNames) {
                        this.logger.trace("Copy[{}] start", (Object)name);
                        target = StringUtil.nvl((String[])new String[]{this.mapper.map(name), name});
                        InputStream in = null;
                        OutputStream out = null;
                        try {
                            ITemplate template = provider.getTemplate(name);
                            if (template != null) {
                                in = template.open();
                                out = storage.getTarget(target);
                                ExecutionContext.getCurrentContext().getPrompter().notify(String.valueOf(target) + " created");
                                IOUtil.redirect((InputStream)in, (OutputStream)out);
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtil.tryClose((Object[])new Object[]{in, out});
                            throw throwable;
                        }
                        IOUtil.tryClose((Object[])new Object[]{in, out});
                    }
                }
                for (String name : this.templateNames) {
                    this.logger.trace("Template[{}] start", (Object)name);
                    target = StringUtil.nvl((String[])new String[]{this.mapper.map(name), name});
                    OutputStream out = storage.getTarget(target);
                    try {
                        this.engine.generate(name, models, out);
                        ExecutionContext.getCurrentContext().getPrompter().notify(String.valueOf(target) + " created");
                    }
                    catch (Throwable throwable) {
                        IOUtil.tryClose((Object[])new Object[]{out});
                        throw throwable;
                    }
                    IOUtil.tryClose((Object[])new Object[]{out});
                }
            }
            catch (IOException e) {
                throw new TemplateException((Throwable)e);
            }
            catch (Exception e) {
                throw new TemplateException((Throwable)e);
            }
        }
        finally {
            context.remove();
            this.logger.info("End template process...");
        }
    }

    protected void checkVersion(String version) throws UnsupportedVersionException {
    }
}

