/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.util.TargetUtil;

public class ZipUtil {
    private static final Logger log = LoggerFactory.getLogger(TargetUtil.class);
    private static final int BUFFER_SIZE = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File targetDir, boolean fileNameToLowerCase) throws Exception {
        FileInputStream fis = null;
        ZipInputStream zis = null;
        ZipEntry zentry = null;
        try {
            fis = new FileInputStream(zipFile);
            zis = new ZipInputStream(fis);
            while ((zentry = zis.getNextEntry()) != null) {
                File targetFileObj;
                String fileNameToUnzip = zentry.getName();
                if (fileNameToLowerCase) {
                    fileNameToUnzip = fileNameToUnzip.toLowerCase();
                }
                File targetFile = new File(targetDir, fileNameToUnzip);
                if (zentry.isDirectory()) {
                    targetFileObj = new File(targetFile.getAbsolutePath());
                    if (targetFileObj.mkdirs()) continue;
                    log.error("Unable to create directory" + targetFileObj.toString());
                    continue;
                }
                targetFileObj = new File(targetFile.getParent());
                if (!targetFileObj.mkdirs()) {
                    log.error("Unable to create directory" + targetFileObj.toString());
                }
                ZipUtil.unzipEntry(zis, targetFile);
            }
        }
        catch (Exception e) {
            log.error("Exception Occured" + e.getMessage());
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File unzipEntry(ZipInputStream zis, File targetFile) throws Exception {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(targetFile);
            byte[] buffer = new byte[2048];
            int len = 0;
            while ((len = zis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
        return targetFile;
    }
}

