/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Policy;
import org.tizen.common.core.command.file.FileHandlingCommand;
import org.tizen.common.core.command.policy.FilePolicy;
import org.tizen.common.core.command.policy.MessagePolicy;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.util.Assert;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;

public class ZipCommand
extends FileHandlingCommand<Object> {
    protected final String baseDir;
    private IResource[] resources = null;

    public ZipCommand(String baseDir, String target) {
        this(baseDir, null, target);
    }

    public ZipCommand(String baseDir, IResource[] resources, String target) {
        this.baseDir = baseDir;
        this.resources = resources;
        this.setPath(target);
    }

    @Override
    public void run(Executor executor, ExecutionContext context) throws IOException {
        FileHandler handler = context.getFileHandler();
        Assert.notNull(handler);
        if (!handler.is(this.baseDir, FileHandler.Attribute.EXISTS)) {
            Policy policy = context.getPolicy("nonexist.dir.in");
            if (policy == null) {
                throw new IllegalStateException("Could not find a policy : nonexist.dir.in");
            }
            MessagePolicy messagePolicy = policy.adapt(MessagePolicy.class);
            if (messagePolicy != null) {
                messagePolicy.print(context.getPrompter(), "{0} doesn't exist.", this.baseDir);
            }
            return;
        }
        if (handler.is(this.path, FileHandler.Attribute.EXISTS)) {
            FilePolicy filePolicy;
            Policy policy = context.getPolicy("exist.file.out.wgt");
            if (policy == null) {
                throw new IllegalStateException("Could not find a policy : exist.file.out.wgt");
            }
            MessagePolicy messagePolicy = policy.adapt(MessagePolicy.class);
            if (messagePolicy != null) {
                messagePolicy.print(context.getPrompter(), "Package already exist.", new Object[0]);
            }
            if (FilePolicy.OVERWRITE.equals((Object)(filePolicy = policy.adapt(FilePolicy.class)))) {
                this.logger.debug("No operation");
            } else {
                return;
            }
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ZipOutputStream zipOut = this.createZipOutputStream(byteOut);
        try {
            if (this.resources != null) {
                IResource[] iResourceArray = this.resources;
                int n = this.resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    this.addEntry(zipOut, resource.getFileHandler(), resource.getPath());
                    ++n2;
                }
            } else {
                this.addEntry(zipOut, handler, this.baseDir);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(zipOut);
            throw throwable;
        }
        IOUtil.tryClose(zipOut);
        ByteArrayInputStream is = new ByteArrayInputStream(byteOut.toByteArray());
        try {
            try {
                handler.write(this.path, is);
                context.getPrompter().notify(MessageFormat.format("Package( {0} ) is created successfully.", this.path));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(is);
            throw throwable;
        }
        IOUtil.tryClose(is);
    }

    protected void addEntry(ZipOutputStream zipOut, FileHandler handler, String filePath) {
        block8: {
            try {
                Object type = handler.get(filePath, FileHandler.Attribute.TYPE);
                this.logger.trace("File path :{}", (Object)filePath);
                if (!FilenameUtil.equals(filePath, this.baseDir) && !this.filter.accept(this.baseDir, FilenameUtil.getRelativePath(this.baseDir, filePath))) {
                    this.logger.debug("Ignore {}", (Object)filePath);
                    return;
                }
                this.logger.trace("file [{}]'s type :{}", (Object)filePath, type);
                if (FileHandler.Type.DIRECTORY.equals(type)) {
                    Collection<String> children = handler.list(filePath);
                    TreeSet<String> safe = new TreeSet<String>(new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            if (o1.equals(o2)) {
                                return 0;
                            }
                            if (o1.equals("META-INF")) {
                                return -1;
                            }
                            if (o2.equals("META-INF")) {
                                return 1;
                            }
                            return o1.compareTo(o2);
                        }
                    });
                    safe.addAll(children);
                    children = safe;
                    this.logger.debug("Files :{}", children);
                    if (!FilenameUtil.equals(this.baseDir, filePath)) {
                        String relative = FilenameUtil.getRelativePath(this.baseDir, filePath);
                        this.logger.trace("Relative path :{}", (Object)relative);
                        ZipEntry entry = this.createEntry(String.valueOf(relative) + "/");
                        zipOut.putNextEntry(entry);
                        zipOut.closeEntry();
                    }
                    for (String child : children) {
                        this.addEntry(zipOut, handler, child);
                    }
                    break block8;
                }
                if (!FileHandler.Type.FILE.equals(type)) break block8;
                String relative = FilenameUtil.getRelativePath(this.baseDir, filePath);
                this.logger.trace("Relative path :{}", (Object)relative);
                InputStream fileIn = handler.read(filePath);
                try {
                    ZipEntry entry = this.createEntry(relative);
                    zipOut.putNextEntry(entry);
                    IOUtil.redirect(fileIn, zipOut);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose(fileIn);
                    zipOut.closeEntry();
                    throw throwable;
                }
                IOUtil.tryClose(fileIn);
                zipOut.closeEntry();
                this.logger.debug("Zip {}", (Object)relative);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected ZipOutputStream createZipOutputStream(OutputStream out) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(out);
        zipOut.setMethod(8);
        zipOut.setLevel(9);
        return zipOut;
    }

    protected ZipEntry createEntry(String name) {
        return new ZipEntry(name);
    }
}

