/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.cli.common;

import java.util.List;
import org.tizen.library.sdkutils.cli.common.Option;
import org.tizen.library.sdkutils.cli.common.Options;

public class Command {
    private String shortCommand;
    private String command;
    private String description;
    private Options options;
    private Options runOptions;
    private boolean visible;

    Command(Command object) {
        this.shortCommand = object.getShortCommand();
        this.command = object.getCommand();
        this.description = object.getDescription();
        this.options = object.getOptions();
    }

    Command(String command, String description) {
        this(command, description, null);
    }

    Command(String command, String description, Options options) {
        this(null, command, description, options);
    }

    Command(String shortCmd, String command, String description, Options options) {
        this(shortCmd, command, description, options, true);
    }

    Command(String shortCmd, String command, String description, Options options, boolean visible) {
        this.shortCommand = shortCmd;
        this.command = command;
        this.description = description;
        this.options = options;
        this.visible = visible;
    }

    public String getShortCommand() {
        return this.shortCommand;
    }

    public void setShortCommand(String shortCommand) {
        this.shortCommand = shortCommand;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public boolean hasOptions() {
        return this.options != null && this.options.hasOption();
    }

    public boolean hasRunOptions() {
        return this.runOptions != null && this.runOptions.hasOption();
    }

    public Options getRunOptions() {
        return this.runOptions;
    }

    public void setRunOptions(Options options) {
        if (options != null) {
            this.runOptions = options;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void printHelp() {
        System.out.println(String.format("Usage:  [global options] %s [options] ...", this.getCommand()));
        System.out.println("Command:");
        System.out.println(String.format("\t%-20s %s", this.getCommand(), this.getDescription()));
        System.out.println("Options:");
        for (Option option : this.options.getOptions()) {
            StringBuffer sb = new StringBuffer();
            sb.append(option.getOption()).append(" ");
            if (option.isHasArg()) {
                sb.append(option.getPrintArgName());
            }
            String DescStr = ": " + option.getDescription();
            System.out.println(String.format("\t%-30s %s", sb.toString(), DescStr));
        }
    }

    public String getUndefinedRequiredOption() {
        List<Option> optionList = this.options.getOptions();
        for (Option opt : optionList) {
            if (!opt.isRequired() || this.runOptions.containsOption(opt)) continue;
            return opt.getOption();
        }
        return null;
    }
}

