/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.core;

import java.util.AbstractList;
import java.util.Collection;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommands;
import org.tizen.ncli.core.CommandLineParser;

public class TizenSubCommandHandler
extends OptionHandler<Object> {
    private SubCommands commands;

    public TizenSubCommandHandler(CmdLineParser parser, OptionDef option, Setter<Object> setter) {
        super(parser, option, setter);
        this.commands = setter.asAnnotatedElement().getAnnotation(SubCommands.class);
        if (this.commands == null) {
            throw new IllegalStateException("SubCommandHandler must be used with @SubCommands annotation");
        }
    }

    public int parseArguments(Parameters params) throws CmdLineException {
        String subCmd = params.getParameter(0);
        for (SubCommand c : this.commands.value()) {
            if (!c.name().equals(subCmd)) continue;
            this.setter.addValue(this.subCommand(c, params));
            return params.size();
        }
        return this.fallback(subCmd);
    }

    protected int fallback(String subCmd) throws CmdLineException {
        throw new CmdLineException(this.owner, Messages.ILLEGAL_OPERAND.format(new Object[]{this.option.toString(), subCmd}));
    }

    protected Object subCommand(SubCommand c, final Parameters params) throws CmdLineException {
        Object subCmd = this.instantiate(c);
        CmdLineParser p = this.configureParser(subCmd, c);
        p.parseArgument((Collection)new AbstractList<String>(){

            @Override
            public String get(int index) {
                try {
                    return params.getParameter(index + 1);
                }
                catch (CmdLineException e) {
                    throw new IndexOutOfBoundsException();
                }
            }

            @Override
            public int size() {
                return params.size() - 1;
            }
        });
        return subCmd;
    }

    protected CmdLineParser configureParser(Object subCmd, SubCommand c) {
        return new CommandLineParser(subCmd);
    }

    protected Object instantiate(SubCommand c) {
        try {
            return c.impl().newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to instantiate " + c, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to instantiate " + c, e);
        }
    }

    public String getDefaultMetaVariable() {
        return "";
    }

    public SubCommands getSubcommand() {
        return this.commands;
    }
}

