/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.core.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.config.Loader;
import org.tizen.common.config.Preference;
import org.tizen.common.config.PreferenceProvider;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.util.Assert;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.ncli.config.ConfigConstant;
import org.tizen.ncli.core.config.TizenCLIConfigProvider;
import org.tizen.ncli.exceptions.UnexpectedException;

public class NCLIConfigLoader
implements Loader {
    private static final String configFileName = ".tizen-cli-config";
    private static Logger log = LoggerFactory.getLogger(NCLIConfigLoader.class);

    public void load(String ns) throws IOException {
        Assert.notNull((Object)ns, (String)"Namespace could not be null");
        if ("TIZEN.CLI.GLOBAL".equals(ns)) {
            Preference.register((String)ns, (PreferenceProvider)new TizenCLIConfigProvider(NCLIConfigLoader.loadGlobalConf()));
        } else if ("TIZEN.CLI.LOCAL".equals(ns)) {
            Preference.register((String)ns, (PreferenceProvider)new TizenCLIConfigProvider(NCLIConfigLoader.loadLocalConf()));
        }
    }

    public static Properties loadLocalConf() {
        return NCLIConfigLoader.loadConf(NCLIConfigLoader.getLocalConfigFile(), true);
    }

    public static Properties loadGlobalConf() {
        return NCLIConfigLoader.loadConf(NCLIConfigLoader.getGlobalConfigFile(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static Properties loadConf(File file, boolean needDefaultValue) {
        block13: {
            block12: {
                block11: {
                    inStream = null;
                    prop = null;
                    isConfExist = file.exists();
                    NCLIConfigLoader.log.trace("isConfExist:{}", (Object)isConfExist);
                    if (!isConfExist) ** GOTO lbl22
                    inStream = new FileInputStream(file);
                    prop = new Properties();
                    prop.load(inStream);
                    if (NCLIConfigLoader.isOldVersion(file)) break block11;
                    var5_7 = prop;
                    IOUtil.tryClose((Object[])new Object[]{inStream});
                    return var5_7;
                }
                try {
                    block14: {
                        newProperties = ConfigConstant.getDefaultValues();
                        for (Map.Entry<Object, Object> property : newProperties.entrySet()) {
                            prop.put(property.getKey(), property.getValue());
                        }
                        break block14;
lbl22:
                        // 1 sources

                        NCLIConfigLoader.log.info("{} file does not exist.", (Object)file.getAbsolutePath());
                        prop = ConfigConstant.getDefaultValues();
                    }
                    if (!needDefaultValue) break block12;
                    NCLIConfigLoader.writeProperties2File(file, prop);
                    profileFile = new File(prop.getProperty("default.profiles.path"));
                    if (profileFile.getPath().equals("") || profileFile.exists()) break block12;
                    profileDir = profileFile.getParentFile();
                    if (profileDir != null && !profileDir.exists() && !profileDir.mkdirs()) {
                        throw new UnexpectedException(2, "Cannot create the default security profile directory.");
                    }
                    profileFile.createNewFile();
                    fos = null;
                    try {
                        fos = new FileOutputStream(profileFile);
                        new SigningProfileContainer().writeProfileXML((OutputStream)fos);
                        NCLIConfigLoader.log.info("Initially wrote to '{}'.", (Object)profileFile);
                    }
                    catch (Throwable var8_11) {
                        IOUtil.tryClose((Object[])new Object[]{fos});
                        throw var8_11;
                    }
                    IOUtil.tryClose((Object[])new Object[]{fos});
                }
                catch (FileNotFoundException e) {
                    NCLIConfigLoader.log.error("FileNotFoundException occurred: {}", (Object)file.getAbsolutePath());
                    IOUtil.tryClose((Object[])new Object[]{inStream});
                    break block13;
                }
                catch (IOException io) {
                    NCLIConfigLoader.log.error("IOException occurred: {}", (Object)file.getAbsolutePath());
                    {
                        catch (Throwable var9_12) {
                            IOUtil.tryClose((Object[])new Object[]{inStream});
                            throw var9_12;
                        }
                    }
                    IOUtil.tryClose((Object[])new Object[]{inStream});
                }
            }
            IOUtil.tryClose((Object[])new Object[]{inStream});
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean isOldVersion(File file) {
        block9: {
            BufferedReader reader;
            block8: {
                boolean bl;
                String comment;
                block7: {
                    reader = null;
                    reader = new BufferedReader(new FileReader(file));
                    comment = reader.readLine();
                    if (comment != null) break block7;
                    boolean bl2 = false;
                    IOUtil.tryClose((Object[])new Object[]{reader});
                    return bl2;
                }
                try {
                    String version;
                    int start = comment.indexOf(40);
                    int end = comment.indexOf(41, start);
                    if (start < 0 || end < 0 || (version = comment.substring(start + 1, end)).compareTo("1.2") < 0) break block8;
                    bl = false;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    IOUtil.tryClose((Object[])new Object[]{reader});
                    break block9;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            IOUtil.tryClose((Object[])new Object[]{reader});
                            throw throwable;
                        }
                    }
                    IOUtil.tryClose((Object[])new Object[]{reader});
                }
                IOUtil.tryClose((Object[])new Object[]{reader});
                return bl;
            }
            IOUtil.tryClose((Object[])new Object[]{reader});
        }
        return true;
    }

    public static File getLocalConfigFile() {
        return NCLIConfigLoader.getConfigFile(InstallPathConfig.getToolsPath());
    }

    public static File getGlobalConfigFile() {
        return NCLIConfigLoader.getConfigFile(System.getProperty("user.home"));
    }

    public static File getConfigFile(String pathName) {
        return new File(pathName + HostUtil.FILE_SEPARATOR + configFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean writeProperties2File(File file, Properties load) {
        Assert.notNull((Object)file, (String)"There is no file to write.File is Null!");
        Assert.notNull((Object)load, (String)"There is no properties to store.");
        FileOutputStream ous = null;
        try {
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (Exception e) {
                    log.error("Unable to create file");
                }
            }
            ous = new FileOutputStream(file);
            load.store(ous, "This is generated by Tizen CLI! (1.2)");
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFoundException occurred while writing default CLI config.");
            e.printStackTrace();
            boolean bl = false;
            IOUtil.tryClose((Object[])new Object[]{ous});
            return bl;
        }
        catch (IOException ie) {
            log.error("IOException occurred while writing default CLI config.");
            ie.printStackTrace();
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{ous});
                    throw throwable;
                }
            }
            IOUtil.tryClose((Object[])new Object[]{ous});
            return bl;
        }
        IOUtil.tryClose((Object[])new Object[]{ous});
        return true;
    }
}

