/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.clean;

import java.io.File;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.util.DirectoryUtil;

public class CleanNativeProjectCommand
extends AbstractSubCommand<CleanNativeProjectCommand> {
    public int clean_count = 0;

    @Override
    protected CleanNativeProjectCommand call() {
        File releaseBuildPath;
        String workingPath = this.workingDir.toString();
        File debugBuildPath = new File(workingPath, "Debug");
        if (debugBuildPath.exists()) {
            if (DirectoryUtil.deleteDirectory(debugBuildPath)) {
                ++this.clean_count;
                this.progressLog.info("native-app (Debug) clean success.");
            } else {
                this.progressLog.error("native-app (Debug) clean failed.");
                throw new UnexpectedException(2, "native-app (Debug) clean failed.");
            }
        }
        if ((releaseBuildPath = new File(workingPath, "Release")).exists()) {
            if (DirectoryUtil.deleteDirectory(releaseBuildPath)) {
                ++this.clean_count;
                this.progressLog.info("native-app (Release) clean success.");
            } else {
                this.progressLog.error("native-app (Release) clean failed.");
                throw new UnexpectedException(2, "native-app (Release) clean failed.");
            }
        }
        return this;
    }
}

