/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.listresource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.createresource.CreateResourceProjectCommandData;
import org.tizen.ncli.subcommands.createresource.ResourceProjectInfo;
import org.tizen.ncli.subcommands.listresource.ListResourceProject;
import org.tizen.ncli.subcommands.listresource.ProfileCompare;

public class ListResourceProjectCLICommand
extends AbstractSubCommand<ListResourceProject> {
    private final String VIEW_FORMAT = "%s";
    private final String TITLE_FORMAT = String.format("%s", "[TEMPLATE]");

    @Override
    protected ListResourceProject call() {
        Map<ResourceProjectInfo, String> resourceProjectMap = CreateResourceProjectCommandData.getTemplateListFromPackage();
        if (resourceProjectMap != null && !resourceProjectMap.isEmpty()) {
            this.progressLog.info(this.TITLE_FORMAT);
            Set<ResourceProjectInfo> resourceProjectInfoSet = resourceProjectMap.keySet();
            ArrayList<ResourceProjectInfo> resourceProjectList = new ArrayList<ResourceProjectInfo>(resourceProjectInfoSet);
            Collections.sort(resourceProjectList, new ProfileCompare());
            for (ResourceProjectInfo info : resourceProjectList) {
                String projectInfo = String.format("%s", info.getTemplateId());
                this.progressLog.info(projectInfo);
            }
        } else {
            this.progressLog.error("Not Found Resource templates");
            throw new UnexpectedException(2, "Not Found Resource templates");
        }
        return null;
    }
}

