/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.builder.util;

import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.IBuildDependency;
import org.tizen.common.builder.IDependency;
import org.tizen.common.file.IResource;

public class DependencyUtil {
    private static final Logger logger = LoggerFactory.getLogger(DependencyUtil.class);

    public static void removeDependencyTargets(IBuildDependency buildDependency, IResource resource, boolean removeOneSelf) throws IOException {
        if (buildDependency == null) {
            logger.error("{}'s build dependency does not exist", (Object)resource.getPath());
            return;
        }
        Set<IDependency> dependencies = null;
        try {
            dependencies = buildDependency.edgesOf(resource);
        }
        catch (IllegalArgumentException e) {
            logger.debug(e.getMessage());
            buildDependency.removeVertex(resource);
            return;
        }
        if (dependencies == null || dependencies.isEmpty()) {
            if (removeOneSelf) {
                buildDependency.removeVertex(resource);
            }
            return;
        }
        for (IDependency dependency : dependencies) {
            IResource targetResource = dependency.getTarget();
            if (targetResource == null) continue;
            if (targetResource.equals(resource)) {
                if (!removeOneSelf) continue;
                buildDependency.removeVertex(resource);
                buildDependency.removeEdge(dependency);
                resource.getFileHandler().removeFile(resource.getPath());
                continue;
            }
            DependencyUtil.removeDependencyTargets(buildDependency, targetResource, true);
        }
    }
}

