/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.preferences;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.sign.preferences.Messages;

public class FileBrowserCellEditor
extends DialogCellEditor {
    private Text text;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private ModifyListener modifyListener;
    private Button button;

    public FileBrowserCellEditor(Composite parent) {
        super(parent, 0);
        this.doSetValue("");
    }

    public FileBrowserCellEditor(Composite parent, boolean toModify) {
        this(parent);
    }

    protected String[] getDialogFilter() {
        return new String[]{"*.p12"};
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        FileDialog dialog = new FileDialog(cellEditorWindow.getShell(), 0);
        dialog.setFilterExtensions(this.getDialogFilter());
        dialog.setText(Messages.FileBrowserCellEditor_2);
        Object value = this.getValue();
        if (value != null) {
            dialog.setFileName((String)value);
        }
        String filePath = dialog.open();
        return filePath;
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.setText("..");
        this.button = result;
        return result;
    }

    protected Control createContents(Composite cell) {
        this.text = new Text(cell, this.getStyle());
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FileBrowserCellEditor.this.handleDefaultSelection(e);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                FileBrowserCellEditor.this.keyReleaseOccured(e);
                if (FileBrowserCellEditor.this.getControl() == null || FileBrowserCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                FileBrowserCellEditor.this.checkSelection();
                FileBrowserCellEditor.this.checkDeleteable();
                FileBrowserCellEditor.this.checkSelectable();
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FileBrowserCellEditor.this.checkSelection();
                FileBrowserCellEditor.this.checkDeleteable();
                FileBrowserCellEditor.this.checkSelectable();
            }
        });
        this.text.setFont(cell.getFont());
        this.text.setBackground(cell.getBackground());
        this.text.addModifyListener(this.getModifyListener());
        return this.text;
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FileBrowserCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    protected void editOccured(ModifyEvent e) {
        String value = this.text.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        this.valueChanged(oldValidState, newValidState);
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.text.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    protected void handleDefaultSelection(SelectionEvent event) {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void updateContents(Object value) {
        if (this.text == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.text.setText(text);
    }

    protected void doSetValue(Object value) {
        this.text.removeModifyListener(this.getModifyListener());
        if (value == null) {
            value = "";
        }
        this.text.setText((String)value);
        this.text.addModifyListener(this.getModifyListener());
        super.doSetValue(value);
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
        this.button.setFocus();
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.text != null && !this.text.isDisposed() && (this.text.getStyle() & 2) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                super.keyReleaseOccured(keyEvent);
            }
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    public boolean isDeleteEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0 || this.text.getCaretPosition() < this.text.getCharCount();
    }
}

