/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;
import org.kohsuke.args4j.spi.StringOptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.web.BuildWebParameter;
import org.tizen.common.core.web.TextProgressMonitor;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.build.buildweb.BuildWebCLICommand;

@TizenSubCommand(name="build-web", usage="Build a Tizen web project.")
public class BuildWebCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-opt", aliases={"--optimize"}, usage="Optimize the application size. The JavaScript and CSS files are minimized and the Tizen Web UI framework source is excluded. The related link address is modified to a platform dependent location instead.")
    public boolean optimize;
    @Option(name="-out", aliases={"--output"}, metaVar="<output path>", handler=StringOptionHandler.class, usage="Set the output directory name. If you omit this option, the .buildResult directory is created under the project directory by default.")
    public String outputName;
    @Option(name="-euf", aliases={"--exclude-uifw"}, usage="Specify whether to exclude the Tizen Web UI framework, and use the Tizen UI framework in the target. This option is only used for applications using the Tizen UI framework.")
    public boolean excludeUIFW;
    @Option(name="-e", aliases={"--exclude"}, metaVar="<files>", handler=StringArrayOptionHandler.class, usage="Specify a list of exclude files by patterns.")
    public String[] excludeArray;
    private List<String> excludeList;

    @Override
    public int execute() {
        int result = -1;
        this.log.trace("Execute BuildWebCLI...");
        BuildWebCLICommand command = new BuildWebCLICommand();
        this.log.trace("getRealWorkingPath:{}", (Object)this.getRealWorkingPath());
        if (null != this.outputName) {
            command.setOutputName(this.outputName);
        }
        if (null != this.excludeArray) {
            this.excludeList = new ArrayList<String>(Arrays.asList(this.excludeArray));
            command.setExcludeList(this.excludeList);
        }
        command.setOptimize(this.optimize);
        command.setExcludeUIFW(this.excludeUIFW);
        command.setWorkingDir(this.getRealWorkingPath());
        command.setProgressMonitor(new TextProgressMonitor(new PrintWriter(System.out)));
        BuildWebParameter commandData = (BuildWebParameter)command.runCommand();
        if (commandData != null) {
            this.progressLog.info("Output path : {}", (Object)commandData.getOutputName());
            if (null != commandData.getExcludeList()) {
                this.progressLog.info("Excluded : {}", commandData.getExcludeList());
            }
            result = 0;
        }
        return result;
    }

    @Override
    public boolean needPrintTime() {
        return true;
    }
}

