/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.createresource;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.createresource.CreateResourceProjectCommandData;
import org.tizen.ncli.subcommands.createresource.ResourceProjectInfo;

public class CreateResourceProjectCommand
extends AbstractSubCommand<CreateResourceProjectCommandData> {
    public CreateResourceProjectCommandData data = new CreateResourceProjectCommandData();
    Map<ResourceProjectInfo, String> resourceProjects = this.data.getTemplateList();

    public CreateResourceProjectCommandData getData() {
        return this.data;
    }

    @Override
    protected CreateResourceProjectCommandData call() {
        if (this.resourceProjects == null || this.resourceProjects.size() == 0) {
            this.progressLog.error("No templates found");
            throw new UnexpectedException(2, "No templates found");
        }
        try {
            if (this.copyResourceProjectTemplate() == -1) {
                this.progressLog.error("Failed to create resource project");
                throw new UnexpectedException(2, "Failed to create resource project");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.data;
    }

    private int copyResourceProjectTemplate() throws IOException {
        File[] fileList;
        String templateName = this.data.getTemplateName();
        String destDir = this.data.getOutputName();
        File destDirFile = new File(destDir);
        String templatePath = null;
        for (Map.Entry<ResourceProjectInfo, String> entry : this.resourceProjects.entrySet()) {
            if (!entry.getKey().getTemplateId().equals(templateName)) continue;
            templatePath = this.data.getTizenResourceTemplateRootPath(entry.getKey());
            break;
        }
        if (templatePath == null) {
            this.progressLog.error(String.format("Cannot find '%s' template", templateName));
            return -1;
        }
        File templatePathFile = new File(templatePath);
        if (templatePathFile == null || !templatePathFile.exists()) {
            this.progressLog.error(String.format("Cannot find '%s' template", templateName));
            return -1;
        }
        if (!new File(templatePath + File.separator + "project" + File.separator + "project_def.prop").exists()) {
            this.progressLog.error(String.format("Cannot find '%s' file in '%s' template", "project_def.prop", templateName));
            return -1;
        }
        if (destDirFile.exists()) {
            this.progressLog.error("'%s' already exists", (Object)destDirFile.getName());
            return -1;
        }
        for (File file : fileList = templatePathFile.listFiles()) {
            if (!file.isDirectory() || !file.getName().equals("project")) continue;
            FileUtils.copyDirectory((File)file, (File)destDirFile, (boolean)false);
            break;
        }
        return 0;
    }
}

