/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.util.cryptutil;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sign.util.cryptutil.ICrypt;
import org.tizen.common.util.IOUtil;

public class LinuxCrypt
implements ICrypt {
    private static final Logger logger = LoggerFactory.getLogger(LinuxCrypt.class);
    private static final String TOOL = Paths.get(InstallPathConfig.getToolsPath(), "certificate-encryptor", "secret-tool").toString();
    private static final String STORE = "store";
    private static final String LOOK = "lookup";
    private static final String LABEL = "--label=\"tizen-studio\"";
    private static final String ATTR1 = "keyfile";
    private static final String ATTR2 = "tool";
    private static final String ATTR2_VAL = "certificate-manager";
    private static final String PASSWORD = "-p";

    @Override
    public void encrypt(String password, String filename) {
        new Thread(() -> {
            String pswd = StringEscapeUtils.escapeJava((String)password);
            String[] CMD_ARRAY = new String[]{TOOL, STORE, LABEL, PASSWORD, pswd, ATTR1, filename, ATTR2, ATTR2_VAL};
            try {
                ProcessBuilder builder = new ProcessBuilder(CMD_ARRAY);
                Process process = builder.start();
                process.waitFor();
            }
            catch (IOException ioe) {
                logger.error("Exception occurred while encrypting the password.", (Throwable)ioe);
            }
            catch (InterruptedException e) {
                logger.error("Exception occurred while encrypting the password.", (Throwable)e);
            }
        }).start();
    }

    @Override
    public String decrypt(String filename) {
        String line;
        block7: {
            String[] CMD_ARRAY = new String[]{TOOL, LOOK, LABEL, ATTR1, filename, ATTR2, ATTR2_VAL};
            line = null;
            ProcessBuilder builder = new ProcessBuilder(CMD_ARRAY);
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            InputStream error = null;
            BufferedReader errorBuffer = null;
            try {
                try {
                    Process process = builder.start();
                    error = process.getErrorStream();
                    errorBuffer = new BufferedReader(new InputStreamReader(error));
                    inputStream = process.getInputStream();
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    line = bufferedReader.readLine();
                    if (errorBuffer.ready() && line == null) {
                        process = builder.start();
                        inputStream = process.getInputStream();
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        line = bufferedReader.readLine();
                    }
                }
                catch (IOException e) {
                    logger.error("Exception occurred while decrypting the password.", (Throwable)e);
                    IOUtil.tryClose((Object[])new Object[]{bufferedReader, errorBuffer});
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{bufferedReader, errorBuffer});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{bufferedReader, errorBuffer});
        }
        if (line != null) {
            return StringEscapeUtils.unescapeJava(line);
        }
        return "";
    }
}

