<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:tizen="http://tizen.org/ns/widgets"
                              xmlns:widget="http://www.w3.org/ns/widgets"
                              xmlns:manifest="http://tizen.org/ns/packages">
    <xsl:output encoding="UTF-8" indent="yes" method="xml" />

    <!-- native manifest name space -->
    <xsl:param name="manifest" select="'http://tizen.org/ns/packages'"/>

    <xsl:template match="/">
        <xsl:apply-templates select="/root/manifest/manifest:manifest[1]"/>
    </xsl:template>

    <!-- root template -->
    <xsl:template match="/root/manifest/manifest:manifest">
        <xsl:text>&#xa;</xsl:text>
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="package">
                <xsl:value-of select="//widget:widget/tizen:application/@package"/>
            </xsl:attribute>
            <xsl:attribute name="version">
                <xsl:value-of select="//widget:widget/@version"/>
            </xsl:attribute>
            <xsl:apply-templates select="*[not(self::manifest:service-application)
                                         and not(self::manifest:widget-application)
                                         and not(self::manifest:privileges)
                                         and not(self::manifest:feature)]"/>
            <xsl:apply-templates select="//manifest:manifest/manifest:service-application"/>
            <xsl:apply-templates select="//manifest:manifest/manifest:widget-application"/>
            <xsl:if test="//manifest:manifest/manifest:privileges/manifest:privilege">
                <xsl:text>&#xa;    </xsl:text>
                <xsl:element name="privileges" namespace="{$manifest}">
                    <xsl:apply-templates select="//manifest:manifest/manifest:privileges/manifest:privilege"/>
                <xsl:text>&#xa;    </xsl:text>
                </xsl:element>
            </xsl:if>
            <xsl:apply-templates select="//manifest:manifest/manifest:feature"/>
        </xsl:copy>
    </xsl:template>

    <!--  copy 'service-application' element -->
    <xsl:template match="manifest:service-application">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!-- update 'appid' attribute of 'service-application' element -->
    <xsl:template match="manifest:service-application/@appid">
       <xsl:attribute name="appid">
           <xsl:value-of select="concat(//widget:widget/tizen:application/@package, '.', ../@exec)"/>
       </xsl:attribute>
    </xsl:template>

    <!--  copy 'widget-application' element -->
    <xsl:template match="manifest:widget-application">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!-- update 'appid' attribute of 'widget-application' element -->
    <xsl:template match="manifest:widget-application/@appid">
       <xsl:attribute name="appid">
           <xsl:value-of select="concat(//widget:widget/tizen:application/@package, '.', ../@exec)"/>
       </xsl:attribute>
    </xsl:template>

    <!--  merge 'privileges' element -->
    <xsl:key name="GroupByPrivilege" match="manifest:privilege" use="text()"/>
    <xsl:template match="manifest:privilege">
        <xsl:if test="generate-id()=generate-id(key('GroupByPrivilege', text())[1])">
            <xsl:text>&#xa;        </xsl:text>
            <xsl:copy>
                <xsl:apply-templates select="@*|node()" />
            </xsl:copy>
        </xsl:if>
    </xsl:template>

    <!--  merge 'feature' element -->
    <xsl:key name="GroupByFeautre" match="manifest:feature" use="@name"/>
    <xsl:template match="manifest:feature">
        <xsl:if test="generate-id()=generate-id(key('GroupByFeautre', @name)[1])">
            <xsl:text>&#xa;    </xsl:text>
            <xsl:copy>
                <xsl:apply-templates select="@*|node()" />
            </xsl:copy>
        </xsl:if>
    </xsl:template>

    <!-- copy elements and attributes -->
    <xsl:template match="@*|node()">
    <xsl:if test="parent::manifest:manifest and self::*">
    <xsl:text>&#xa;    </xsl:text>
    </xsl:if>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
