/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeappcommon.templateengine.process;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tizen.common.util.FileUtil;
import org.tizen.nativeappcommon.templateengine.TizenTemplateProcessParser;

public class TizenCopyFolder
extends ProcessRunner {
    private IProject projectHandle;
    protected Map<String, String> valueStore;
    private IPath samplePath;

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        this.projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.valueStore = template.getValueStore();
        String applicationId = null;
        String templateId = template.getTemplateId();
        if ("TizenCppApplicationProject".equals(templateId)) {
            applicationId = "cpp";
        } else if ("EFLCApplicationProject".equals(templateId)) {
            applicationId = "core";
        }
        IPath location = TizenTemplateProcessParser.getSelectedSampleLocationFromMainPage(applicationId);
        if (location == null) {
            return;
        }
        this.samplePath = new Path(location.toFile().getParent());
        ArrayList<ReplaceableFile> replaceableFileList = new ArrayList<ReplaceableFile>();
        String folderPath = args[1].getSimpleValue();
        ProcessArgument[][] replaceableFiles = args[2].getComplexArrayValue();
        int i = 0;
        while (i < replaceableFiles.length) {
            ProcessArgument[] file = replaceableFiles[i];
            String sourcePath = file[0].getSimpleValue();
            if (!sourcePath.equals("")) {
                IPath replaceableFilePath = this.samplePath.append(folderPath).append(sourcePath);
                replaceableFileList.add(new ReplaceableFile(replaceableFilePath, file[1].getSimpleValue(), file[2].getSimpleValue().equals("true")));
            }
            ++i;
        }
        File folderFile = this.samplePath.append(folderPath).toFile();
        if (!folderFile.exists()) {
            throw new ProcessFailureException("Sample folder: " + folderFile.getPath() + " does not exist.");
        }
        this.copyFile(folderFile, replaceableFileList, "");
        try {
            this.projectHandle.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.7")) + e.getMessage(), (Throwable)e);
        }
    }

    protected void copyFile(File files, List<ReplaceableFile> replaces, String targetPath) throws ProcessFailureException {
        File[] fileArray = files.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block31: {
                File file = fileArray[n2];
                InputStream contents = null;
                String newTargetPath = null;
                if (file.isFile()) {
                    boolean found = false;
                    for (ReplaceableFile replace : replaces) {
                        String sourcePath = null;
                        String _targetPath = null;
                        try {
                            sourcePath = replace.getSourcePath().toFile().getCanonicalPath();
                            _targetPath = file.getCanonicalPath();
                        }
                        catch (IOException e) {
                            throw new ProcessFailureException((Throwable)e);
                        }
                        if (!sourcePath.equals(_targetPath)) continue;
                        found = true;
                        newTargetPath = replace.getTargetPath();
                        if (replace.isReplaceable()) {
                            String fileContents = null;
                            try {
                                fileContents = FileUtil.readTextFile((File)file, null);
                                fileContents = ProcessHelper.getValueAfterExpandingMacros((String)fileContents, (Set)ProcessHelper.getReplaceKeys((String)fileContents), this.valueStore);
                                contents = new ByteArrayInputStream(fileContents.getBytes());
                            }
                            catch (MalformedURLException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            replaces.remove(replace);
                            break;
                        }
                        try {
                            contents = file.toURI().toURL().openStream();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!found) {
                        newTargetPath = String.valueOf(targetPath) + File.separator + file.getName();
                        try {
                            contents = file.toURI().toURL().openStream();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        IFile iFile = this.projectHandle.getFile(newTargetPath);
                        File x = iFile.getLocation().toFile();
                        if (!iFile.getParent().exists()) {
                            ProcessHelper.mkdirs((IProject)this.projectHandle, (IFolder)this.projectHandle.getFolder(iFile.getParent().getProjectRelativePath()));
                        }
                        if (iFile.exists()) {
                            ResourceAttributes attributes = iFile.getResourceAttributes();
                            if (attributes != null && !attributes.isReadOnly()) {
                                iFile.setContents(contents, true, true, null);
                            } else if (attributes == null) {
                                iFile.setContents(contents, true, true, null);
                            }
                            break block31;
                        }
                        if (x.exists()) {
                            if (!x.canWrite()) {
                                x.delete();
                                iFile.create(contents, true, null);
                                iFile.refreshLocal(1, null);
                            } else {
                                iFile.create(contents, true, null);
                                iFile.refreshLocal(1, null);
                            }
                            break block31;
                        }
                        iFile.create(contents, true, null);
                        iFile.refreshLocal(1, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                } else if (file.isDirectory()) {
                    newTargetPath = String.valueOf(targetPath) + File.separator + file.getName();
                    if (file.listFiles().length == 0) {
                        try {
                            if (!this.projectHandle.getFolder(newTargetPath).exists()) {
                                ProcessHelper.mkdirs((IProject)this.projectHandle, (IFolder)this.projectHandle.getFolder(newTargetPath));
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.copyFile(file, replaces, newTargetPath);
                    }
                }
            }
            ++n2;
        }
    }

    public static class ReplaceableFile {
        private IPath sourcePath;
        private String targetPath;
        private boolean replaceable;

        public ReplaceableFile(IPath sourcePath, String targetPath, boolean replaceable) {
            this.sourcePath = sourcePath;
            this.targetPath = targetPath;
            this.replaceable = replaceable;
        }

        public IPath getSourcePath() {
            return this.sourcePath;
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public boolean isReplaceable() {
            return this.replaceable;
        }
    }
}

