/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import org.eclipse.cdt.core.settings.model.util.IKindBasedInfo;
import org.eclipse.cdt.core.settings.model.util.UtilMessages;

public class KindBasedStore<T>
implements Cloneable {
    private static final int INDEX_INCLUDE_PATH = 0;
    private static final int INDEX_INCLUDE_FILE = 1;
    private static final int INDEX_MACRO = 2;
    private static final int INDEX_MACRO_FILE = 3;
    private static final int INDEX_LIBRARY_PATH = 4;
    private static final int INDEX_LIBRARY_FILE = 5;
    private static final int LANG_STORAGE_SIZE = 6;
    private static final int INDEX_SOURCE_PATH = 6;
    private static final int INDEX_OUPUT_PATH = 7;
    private static final int ALL_STORAGE_SIZE = 8;
    public static final int ORED_LANG_ENTRY_KINDS = 63;
    public static final int ORED_ALL_ENTRY_KINDS = 255;
    private static final int[] LANG_ENTRY_KINDS = new int[]{1, 2, 4, 8, 16, 32};
    private static final int[] ALL_ENTRY_KINDS = new int[]{1, 2, 4, 8, 16, 32, 128, 64};
    private Object[] fEntryStorage;

    public KindBasedStore() {
        this(true);
    }

    public KindBasedStore(boolean langOnly) {
        this.fEntryStorage = langOnly ? new Object[6] : new Object[8];
    }

    private int kindToIndex(int kind) {
        switch (kind) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 128: {
                if (6 >= this.fEntryStorage.length) break;
                return 6;
            }
            case 64: {
                if (7 >= this.fEntryStorage.length) break;
                return 7;
            }
        }
        throw new IllegalArgumentException(UtilMessages.getString("KindBasedStore.0"));
    }

    public static int[] getLanguageEntryKinds() {
        return (int[])LANG_ENTRY_KINDS.clone();
    }

    public static int[] getAllEntryKinds() {
        return (int[])ALL_ENTRY_KINDS.clone();
    }

    private int indexToKind(int index) {
        switch (index) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 128;
            }
            case 7: {
                return 64;
            }
        }
        throw new IllegalArgumentException(UtilMessages.getString("KindBasedStore.1"));
    }

    public T get(int kind) {
        return (T)this.fEntryStorage[this.kindToIndex(kind)];
    }

    public T put(int kind, T object) {
        int index = this.kindToIndex(kind);
        Object old = this.fEntryStorage[index];
        this.fEntryStorage[index] = object;
        return (T)old;
    }

    public IKindBasedInfo<T>[] getContents() {
        IKindBasedInfo[] infos = new IKindBasedInfo[this.fEntryStorage.length];
        int i = 0;
        while (i < this.fEntryStorage.length) {
            infos[i] = new KindBasedInfo(i, false);
            ++i;
        }
        return infos;
    }

    public IKindBasedInfo<T> getInfo(int kind) {
        return new KindBasedInfo(kind, true);
    }

    public void clear() {
        int i = 0;
        while (i < this.fEntryStorage.length) {
            this.fEntryStorage[i] = null;
            ++i;
        }
    }

    public Object clone() {
        try {
            KindBasedStore clone = (KindBasedStore)super.clone();
            clone.fEntryStorage = (Object[])this.fEntryStorage.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private class KindBasedInfo
    implements IKindBasedInfo<T> {
        int fIdex;
        int fKind;

        KindBasedInfo(int num, boolean isKind) {
            if (isKind) {
                this.fIdex = KindBasedStore.this.kindToIndex(num);
                this.fKind = num;
            } else {
                this.fIdex = num;
                this.fKind = KindBasedStore.this.indexToKind(num);
            }
        }

        @Override
        public T getInfo() {
            Object info = KindBasedStore.this.fEntryStorage[this.fIdex];
            return info;
        }

        @Override
        public int getKind() {
            return this.fKind;
        }

        @Override
        public T setInfo(T newInfo) {
            Object old = KindBasedStore.this.fEntryStorage[this.fIdex];
            ((KindBasedStore)KindBasedStore.this).fEntryStorage[this.fIdex] = newInfo;
            return old;
        }
    }
}

