/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.templateengine.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tizen.nativecommon.templateengine.util.TemplateUtil;
import org.w3c.dom.Element;

public class TizenProcessArgument {
    static final String ELEM_NAME = "name";
    private static final String ELEM_VALUE = "value";
    private static final String ELEM_ELEMENT = "element";
    private static final String ELEM_SIMPLE = "simple";
    private static final String ELEM_SIMPLE_ARRAY = "simple-array";
    private static final String ELEM_COMPLEX = "complex";
    private static final String ELEM_COMPLEX_ARRAY = "complex-array";
    public static final byte SIMPLE = 1;
    public static final byte SIMPLE_ARRAY = 2;
    public static final byte COMPLEX = 3;
    public static final byte COMPLEX_ARRAY = 4;
    private String name;
    private byte type;
    private String simpleValue;
    private String[] simpleValueArray;
    private TizenProcessArgument[] complexValue;
    private TizenProcessArgument[][] complexValueArray;
    private Set<String> macros;

    public TizenProcessArgument(Element elem) {
        block9: {
            String elemName;
            block11: {
                block10: {
                    block8: {
                        this.name = elem.getAttribute(ELEM_NAME);
                        elemName = elem.getNodeName();
                        if (!elemName.equals(ELEM_SIMPLE)) break block8;
                        this.type = 1;
                        this.simpleValue = elem.getAttribute(ELEM_VALUE);
                        this.collectMacros(this.simpleValue);
                        break block9;
                    }
                    if (!elemName.equals(ELEM_SIMPLE_ARRAY)) break block10;
                    this.type = (byte)2;
                    List<Element> valueElements = TemplateUtil.getChildrenOfElementByTag(elem, ELEM_ELEMENT);
                    this.simpleValueArray = new String[valueElements.size()];
                    int i = 0;
                    int l = valueElements.size();
                    while (i < l) {
                        this.simpleValueArray[i] = valueElements.get(i).getAttribute(ELEM_VALUE);
                        this.collectMacros(this.simpleValueArray[i]);
                        ++i;
                    }
                    break block9;
                }
                if (!elemName.equals(ELEM_COMPLEX)) break block11;
                this.type = (byte)3;
                List<Element> children = TemplateUtil.getChildrenOfElement(elem);
                this.complexValue = new TizenProcessArgument[children.size()];
                int i = 0;
                int l = children.size();
                while (i < l) {
                    this.complexValue[i] = new TizenProcessArgument(children.get(i));
                    Set<String> subMacros = this.complexValue[i].getMacros();
                    if (this.macros == null) {
                        this.macros = new HashSet<String>();
                    }
                    if (subMacros != null) {
                        this.macros.addAll(subMacros);
                    }
                    ++i;
                }
                break block9;
            }
            if (!elemName.equals(ELEM_COMPLEX_ARRAY)) break block9;
            this.type = (byte)4;
            List<Element> valueElements = TemplateUtil.getChildrenOfElementByTag(elem, ELEM_ELEMENT);
            this.complexValueArray = new TizenProcessArgument[valueElements.size()][];
            int i = 0;
            int l = valueElements.size();
            while (i < l) {
                List<Element> children = TemplateUtil.getChildrenOfElement(valueElements.get(i));
                this.complexValueArray[i] = new TizenProcessArgument[children.size()];
                int j = 0;
                int l2 = children.size();
                while (j < l2) {
                    this.complexValueArray[i][j] = new TizenProcessArgument(children.get(j));
                    Set<String> subMacros = this.complexValueArray[i][j].getMacros();
                    if (subMacros != null) {
                        if (this.macros == null) {
                            this.macros = new HashSet<String>();
                        }
                        this.macros.addAll(subMacros);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void collectMacros(String value) {
        if (value == null) {
            return;
        }
        if (this.macros == null) {
            this.macros = new HashSet<String>();
        }
        this.macros.addAll(TemplateUtil.getReplaceKeys(value));
    }

    public Set<String> getMacros() {
        return this.macros;
    }

    public String getName() {
        return this.name;
    }

    public byte getParameterType() {
        return this.type;
    }

    public String getSimpleValue() {
        return this.simpleValue;
    }

    public String[] getSimpleArrayValue() {
        return this.simpleValueArray;
    }

    public TizenProcessArgument[] getComplexValue() {
        return this.complexValue;
    }

    public TizenProcessArgument[][] getComplexArrayValue() {
        return this.complexValueArray;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(this.name);
        b.append(":");
        switch (this.type) {
            case 1: {
                return b.append(this.getSimpleValue()).toString();
            }
            case 2: {
                b.append("{");
                String[] strings = this.getSimpleArrayValue();
                int i = 0;
                while (i < strings.length) {
                    b.append(strings[i]).append(", ");
                    ++i;
                }
                if (b.charAt(b.length() - 1) == ' ') {
                    b.replace(b.length() - 2, b.length(), "}");
                } else {
                    b.append("}");
                }
                return b.toString();
            }
            case 3: {
                b.append("{");
                TizenProcessArgument[] args = this.getComplexValue();
                int i = 0;
                while (i < args.length) {
                    TizenProcessArgument arg = args[i];
                    b.append(arg).append(", ");
                    ++i;
                }
                if (b.charAt(b.length() - 1) == ' ') {
                    b.replace(b.length() - 2, b.length(), "}");
                } else {
                    b.append("}");
                }
                return b.toString();
            }
            case 4: {
                b.append("{");
                TizenProcessArgument[][] argssCA = this.getComplexArrayValue();
                int i = 0;
                while (i < argssCA.length) {
                    TizenProcessArgument[] argsCA = argssCA[i];
                    b.append("{");
                    int j = 0;
                    while (j < argsCA.length) {
                        TizenProcessArgument arg = argsCA[j];
                        b.append(arg).append(", ");
                        ++j;
                    }
                    if (b.charAt(b.length() - 1) == ' ') {
                        b.replace(b.length() - 2, b.length(), "}, ");
                    } else {
                        b.append("}, ");
                    }
                    ++i;
                }
                if (b.charAt(b.length() - 1) == ' ') {
                    b.replace(b.length() - 2, b.length(), "}");
                } else {
                    b.append("}");
                }
                return b.toString();
            }
        }
        return "";
    }
}

