/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.misc.core.IconType;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Account {
    public static final String ELEMENT = "account";
    public static final String ATTR_MULTIPLE_ACCOUNT_SUPPORT = "multiple-accounts-support";
    public static final String ATTR_APPID = "appid";
    public static final String ATTR_PROVIDERID = "providerid";
    public static final String ATTR_XMLLANG = "xml:lang";
    public static final String ATTR_SECTION = "section";
    public static final String ELEMENT_ACCOUNT_PROVIDER = "account-provider";
    public static final String ELEMENT_ICON = "icon";
    public static final String ELEMENT_LABEL = "label";
    public static final String ELEMENT_CAPABILITY = "capability";
    public static final String ACCOUNT_SMALL = "account-small";
    public static final String ACCOUNT = "account";
    public static final String STRING_TRUE = "true";
    public static final String STRING_FALSE = "false";
    private String fIsMultipleAccountSupport = "false";
    private String appid;
    private String providerid;
    private String defaultLabel;
    private Icon fIcon = new Icon(IconType.ACCOUNT);
    private Icon fIconSmall = new Icon(IconType.ACCOUNTSMALL);
    private List<LocaledValue> fNames;
    private List<AccountCapability> fCapabilities;
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();

    public String toString() {
        String def = "Account";
        return def;
    }

    public String getMultipleAccountSupport() {
        return this.fIsMultipleAccountSupport;
    }

    public void setMultipleAccountSupport(String v) {
        this.fIsMultipleAccountSupport = v;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getProviderid() {
        return this.providerid;
    }

    public void setProviderid(String providerid) {
        this.providerid = providerid;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public Icon getIcon() {
        return this.fIcon;
    }

    public void setIcon(String icon) {
        this.fIcon.set(icon);
    }

    public Icon getIconSmall() {
        return this.fIconSmall;
    }

    public void setIconSmall(String iconSmall) {
        this.fIconSmall.set(iconSmall);
    }

    public List<LocaledValue> getNames() {
        if (this.fNames == null) {
            this.fNames = new ArrayList<LocaledValue>();
        }
        return this.fNames;
    }

    public void setNames(List<LocaledValue> names) {
        this.fNames = names;
    }

    public List<AccountCapability> getCapabilities() {
        if (this.fCapabilities == null) {
            this.fCapabilities = new ArrayList<AccountCapability>();
        }
        return this.fCapabilities;
    }

    public void addCapabilities(AccountCapability cap) {
        if (this.fCapabilities != null) {
            this.fCapabilities.add(cap);
        }
    }

    public boolean isValid() {
        if (this.fIcon.getFileName() == null || this.fIcon.getFileName().length() == 0) {
            return false;
        }
        if (this.fIconSmall.getFileName() == null || this.fIconSmall.getFileName().length() == 0) {
            return false;
        }
        if (this.getNames().size() == 0) {
            return true;
        }
        return true;
    }

    public void loadElement(Element element) {
        if (!element.getNodeName().equals("account")) {
            return;
        }
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            String attr = node.getNodeName();
            CustomAttribute custom = new CustomAttribute();
            custom.loadAttribute(attr, node.getNodeValue());
            ++i;
        }
        Element accProvider = (Element)element.getElementsByTagName(ELEMENT_ACCOUNT_PROVIDER).item(0);
        if (accProvider != null) {
            this.setMultipleAccountSupport(accProvider.getAttribute(ATTR_MULTIPLE_ACCOUNT_SUPPORT));
            this.setAppid(accProvider.getAttribute(ATTR_APPID));
            this.setProviderid(accProvider.getAttribute(ATTR_PROVIDERID));
            NodeList icons = accProvider.getElementsByTagName(ELEMENT_ICON);
            int i2 = 0;
            while (i2 < icons.getLength()) {
                Element eIcon = (Element)icons.item(i2);
                String section = eIcon.getAttribute(ATTR_SECTION);
                if (section.equals("account")) {
                    this.setIcon(eIcon.getTextContent());
                } else if (section.equals(ACCOUNT_SMALL)) {
                    this.setIconSmall(eIcon.getTextContent());
                }
                ++i2;
            }
            NodeList nodes = accProvider.getElementsByTagName(ELEMENT_LABEL);
            int i3 = 0;
            while (i3 < nodes.getLength()) {
                Element eName = (Element)nodes.item(i3);
                if (eName.getAttribute(ATTR_XMLLANG) != null && eName.getAttribute(ATTR_XMLLANG).length() > 0) {
                    this.getNames().add(new LocaledValue(eName.getAttribute(ATTR_XMLLANG), eName.getTextContent()));
                } else {
                    this.setDefaultLabel(eName.getTextContent());
                }
                ++i3;
            }
            nodes = accProvider.getElementsByTagName(ELEMENT_CAPABILITY);
            i3 = 0;
            while (i3 < nodes.getLength()) {
                Element eCap = (Element)nodes.item(i3);
                String cap = eCap.getTextContent();
                if (cap != null && cap.length() > 0) {
                    this.getCapabilities().add(new AccountCapability(cap));
                }
                ++i3;
            }
        }
        Node childNode = element.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeType() == 1 && this.isCustomElement(childNode.getNodeName())) {
                CustomElement custom = new CustomElement();
                custom.loadElement((Element)childNode);
                this.getCustomElementList().add(custom);
            }
            childNode = childNode.getNextSibling();
        }
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement("account");
        Element eAccProvider = dom.createElement(ELEMENT_ACCOUNT_PROVIDER);
        eAccProvider.setAttribute(ATTR_MULTIPLE_ACCOUNT_SUPPORT, this.getMultipleAccountSupport());
        if (this.getAppid() != null && this.getAppid().length() > 0) {
            eAccProvider.setAttribute(ATTR_APPID, this.getAppid());
        } else {
            eAccProvider.setAttribute(ATTR_APPID, "");
        }
        if (this.getProviderid() != null && this.getProviderid().length() > 0) {
            eAccProvider.setAttribute(ATTR_PROVIDERID, this.getProviderid());
        }
        if (this.fIcon.getFileName() != null && this.fIcon.getFileName().length() > 0) {
            Element element2 = dom.createElement(ELEMENT_ICON);
            element2.setAttribute(ATTR_SECTION, "account");
            element2.setTextContent(this.fIcon.getFileName());
            eAccProvider.appendChild(element2);
        }
        if (this.fIconSmall.getFileName() != null && this.fIconSmall.getFileName().length() > 0) {
            Element element3 = dom.createElement(ELEMENT_ICON);
            element3.setAttribute(ATTR_SECTION, ACCOUNT_SMALL);
            element3.setTextContent(this.fIconSmall.getFileName());
            eAccProvider.appendChild(element3);
        }
        if (this.fNames != null && this.fNames.size() > 0) {
            for (LocaledValue localedValue : this.fNames) {
                Element eName = dom.createElement(ELEMENT_LABEL);
                if (localedValue.getLocale() != null && localedValue.getLocale().length() > 0) {
                    eName.setAttribute(ATTR_XMLLANG, localedValue.getLocale());
                }
                if (localedValue.getValue() != null && localedValue.getValue().length() > 0) {
                    eName.setTextContent(localedValue.getValue());
                }
                eAccProvider.appendChild(eName);
            }
        }
        if (this.defaultLabel != null && this.defaultLabel.length() > 0) {
            Element element4 = dom.createElement(ELEMENT_LABEL);
            element4.setTextContent(this.getDefaultLabel());
            eAccProvider.appendChild(element4);
        }
        if (this.fCapabilities != null && this.fCapabilities.size() > 0) {
            for (AccountCapability accountCapability : this.fCapabilities) {
                Element eCap = dom.createElement(ELEMENT_CAPABILITY);
                if (accountCapability.getCapabilities().length() <= 0) continue;
                eCap.setTextContent(accountCapability.getCapabilities());
                eAccProvider.appendChild(eCap);
            }
        }
        element.appendChild(eAccProvider);
        parent.appendChild(element);
        for (CustomAttribute customAttribute : this.getCustomAttrList()) {
            customAttribute.generateAttribute(element);
        }
        for (CustomElement customElement : this.getCustomElementList()) {
            customElement.generateElement(dom, element);
        }
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }

    private boolean isCustomElement(String nodeName) {
        if (nodeName.equals(ELEMENT_ACCOUNT_PROVIDER)) {
            return false;
        }
        if (nodeName.equals(ELEMENT_ICON)) {
            return false;
        }
        if (nodeName.equals(ELEMENT_LABEL)) {
            return false;
        }
        return !nodeName.equals(ELEMENT_CAPABILITY);
    }

    public static final class AccountCapability {
        public static final String[] ACCOUNT_CAPABILITY_PRESETS = new String[]{"http://tizen.org/account/capability/contact", "http://tizen.org/account/capability/calendar", "http://tizen.org/account/capability/email", "http://tizen.org/account/capability/photo", "http://tizen.org/account/capability/video", "http://tizen.org/account/capability/music", "http://tizen.org/account/capability/document", "http://tizen.org/account/capability/message", "http://tizen.org/account/capability/game"};
        private String fCapabilities;

        public AccountCapability() {
        }

        public AccountCapability(String cap) {
            this.fCapabilities = cap;
        }

        public String toString() {
            String cap = "Capability";
            if (this.fCapabilities == null || this.fCapabilities.length() == 0) {
                return cap;
            }
            return String.valueOf(this.fCapabilities) + " (" + cap + ")";
        }

        public String getCapabilities() {
            return this.fCapabilities;
        }

        public void setCapabilities(String fCapabilities) {
            this.fCapabilities = fCapabilities;
        }
    }
}

