/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.SourceHeaderPartnerFinder;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ToggleSourceAndHeaderAction
extends TextEditorAction {
    private static ITranslationUnit fgLastPartnerUnit;
    private static ITranslationUnit fgLastSourceUnit;

    public ToggleSourceAndHeaderAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        IWorkingCopy currentUnit = this.getWorkingCopy();
        if (currentUnit == null) {
            return;
        }
        ITranslationUnit partnerUnit = this.computePartnerFile((ITranslationUnit)currentUnit);
        if (partnerUnit != null) {
            fgLastSourceUnit = currentUnit.getOriginalElement();
            fgLastPartnerUnit = partnerUnit;
            try {
                EditorUtility.openInEditor(partnerUnit);
            }
            catch (PartInitException exc) {
                CUIPlugin.log(exc.getStatus());
            }
            catch (CModelException exc) {
                CUIPlugin.log(exc.getStatus());
            }
        }
    }

    private IWorkingCopy getWorkingCopy() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    public void update() {
        this.setEnabled(this.getWorkingCopy() != null);
    }

    private ITranslationUnit computePartnerFile(ITranslationUnit tUnit) {
        ITranslationUnit originalUnit;
        if (fgLastPartnerUnit != null && (originalUnit = tUnit instanceof IWorkingCopy ? ((IWorkingCopy)tUnit).getOriginalElement() : tUnit).getTranslationUnit().equals(fgLastPartnerUnit) && fgLastSourceUnit.exists()) {
            return fgLastSourceUnit;
        }
        return SourceHeaderPartnerFinder.getPartnerTranslationUnit(tUnit);
    }
}

