/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.AbstractPage;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteResConfigsHandler
extends AbstractHandler {
    protected ArrayList<IResource> objects;
    private ArrayList<ResCfgData> outData;

    public void setEnabled(Object context) {
        ISelection selection = this.getSelection(context);
        this.setEnabledFromSelection(selection);
    }

    protected ISelection getSelection(Object context) {
        Object s = HandlerUtil.getVariable((Object)context, (String)"activeMenuSelection");
        if (s instanceof ISelection) {
            return (ISelection)s;
        }
        return null;
    }

    public void setEnabledFromSelection(ISelection selection) {
        this.objects = null;
        if (selection != null && !selection.isEmpty()) {
            IFile file;
            Object[] obs = null;
            if (selection instanceof IStructuredSelection) {
                obs = ((IStructuredSelection)selection).toArray();
            } else if (selection instanceof ITextSelection && (file = this.getFileFromActiveEditor()) != null) {
                obs = Collections.singletonList(file).toArray();
            }
            if (obs != null && obs.length > 0) {
                int i = 0;
                while (i < obs.length) {
                    IProject p;
                    IResource res = null;
                    if (obs[i] instanceof ICContainer || obs[i] instanceof ITranslationUnit) {
                        res = ((ICElement)obs[i]).getResource();
                    } else if (obs[i] instanceof IResource && !(obs[i] instanceof IProject)) {
                        res = (IResource)obs[i];
                    }
                    if (res != null && (p = res.getProject()).isOpen() && CoreModel.getDefault().isNewStyleProject(p)) {
                        ICConfigurationDescription[] cfgds;
                        IPath path = res.getProjectRelativePath();
                        ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(p, false);
                        if (prjd != null && (cfgds = prjd.getConfigurations()) != null && cfgds.length != 0) {
                            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgds;
                            int n = cfgds.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ICConfigurationDescription cfgd = iCConfigurationDescriptionArray[n2];
                                ICResourceDescription rd = cfgd.getResourceDescription(path, true);
                                if (rd != null) {
                                    if (this.objects == null) {
                                        this.objects = new ArrayList();
                                    }
                                    this.objects.add(res);
                                    break;
                                }
                                ++n2;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        this.setBaseEnabled(this.objects != null);
    }

    private IFile getFileFromActiveEditor() {
        IEditorInput input;
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null && (input = editor.getEditorInput()) != null) {
            return (IFile)input.getAdapter(IFile.class);
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.openDialog();
        return null;
    }

    private void openDialog() {
        Object[] selected;
        if (this.objects == null || this.objects.size() == 0) {
            return;
        }
        ListSelectionDialog dialog = new ListSelectionDialog(CUIPlugin.getActiveWorkbenchShell(), this.objects, this.createSelectionDialogContentProvider(), (ILabelProvider)new LabelProvider(){}, ActionMessages.DeleteResConfigsAction_0);
        dialog.setTitle(ActionMessages.DeleteResConfigsAction_1);
        if (dialog.open() == 0 && (selected = dialog.getResult()) != null && selected.length > 0) {
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                ((ResCfgData)element).delete();
                AbstractPage.updateViews(((ResCfgData)element).res);
                ++n2;
            }
        }
    }

    private IStructuredContentProvider createSelectionDialogContentProvider() {
        this.outData = null;
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (DeleteResConfigsHandler.this.outData != null) {
                    return DeleteResConfigsHandler.this.outData.toArray();
                }
                DeleteResConfigsHandler.this.outData = new ArrayList();
                List ls = (List)inputElement;
                Iterator it = ls.iterator();
                IProject proj = null;
                ICProjectDescription prjd = null;
                ICConfigurationDescription[] cfgds = null;
                while (it.hasNext()) {
                    IResource res = (IResource)it.next();
                    IPath path = res.getProjectRelativePath();
                    if (res.getProject() != proj) {
                        proj = res.getProject();
                        prjd = CoreModel.getDefault().getProjectDescription(proj);
                        cfgds = prjd.getConfigurations();
                    }
                    if (cfgds == null) continue;
                    ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgds;
                    int n = cfgds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICConfigurationDescription cfgd = iCConfigurationDescriptionArray[n2];
                        ICResourceDescription rd = cfgd.getResourceDescription(path, true);
                        if (rd != null) {
                            DeleteResConfigsHandler.this.outData.add(new ResCfgData(res, prjd, cfgd, rd));
                        }
                        ++n2;
                    }
                }
                return DeleteResConfigsHandler.this.outData.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    class ResCfgData {
        IResource res;
        ICProjectDescription prjd;
        ICConfigurationDescription cfgd;
        ICResourceDescription rdesc;

        public ResCfgData(IResource res2, ICProjectDescription prjd2, ICConfigurationDescription cfgd2, ICResourceDescription rdesc2) {
            this.res = res2;
            this.prjd = prjd2;
            this.cfgd = cfgd2;
            this.rdesc = rdesc2;
        }

        public void delete() {
            try {
                this.cfgd.removeResourceDescription(this.rdesc);
                CoreModel.getDefault().setProjectDescription(this.res.getProject(), this.prjd);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        public String toString() {
            return "[" + this.cfgd.getName() + "] for " + this.res.getName();
        }
    }
}

