/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.filewizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewFileWizardMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class WizardNewFileFromTemplateCreationPage
extends WizardNewFileCreationPage {
    private Combo fTemplatesCombo;
    private Template[] fTemplates;
    protected boolean fUseTemplate = true;

    public WizardNewFileFromTemplateCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    protected void createAdvancedControls(Composite parent) {
        Composite groupComposite = new Composite(parent, 0);
        groupComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        groupComposite.setLayout((Layout)layout);
        final Button useTemplateButton = new Button(groupComposite, 32);
        useTemplateButton.setText(NewFileWizardMessages.WizardNewFileFromTemplateCreationPage_useTemplate_label);
        useTemplateButton.setSelection(this.fUseTemplate);
        SelectionAdapter useTemplateListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardNewFileFromTemplateCreationPage.this.fUseTemplate = useTemplateButton.getSelection();
                WizardNewFileFromTemplateCreationPage.this.fTemplatesCombo.setEnabled(WizardNewFileFromTemplateCreationPage.this.fUseTemplate);
            }
        };
        useTemplateButton.addSelectionListener((SelectionListener)useTemplateListener);
        this.fTemplatesCombo = new Combo(groupComposite, 8);
        this.fTemplatesCombo.setEnabled(this.fUseTemplate);
        this.fTemplatesCombo.setLayoutData((Object)new GridData(768));
        Button configureButton = new Button(groupComposite, 8);
        configureButton.setText(NewFileWizardMessages.WizardNewFileFromTemplateCreationPage_configure_label);
        SelectionAdapter changeTemplateListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardNewFileFromTemplateCreationPage.this.editTemplates();
            }
        };
        configureButton.addSelectionListener((SelectionListener)changeTemplateListener);
        this.updateTemplates();
        super.createAdvancedControls(parent);
    }

    protected void editTemplates() {
        PreferenceDialog dialog;
        String prefPageId = "org.eclipse.cdt.ui.preferences.CodeTemplatePreferencePage";
        HashMap<String, String> data = null;
        String templateName = null;
        Template template = this.getSelectedTemplate();
        if (template != null) {
            templateName = template.getName();
        }
        if (templateName != null) {
            data = new HashMap<String, String>();
            data.put("CodeTemplatePreferencePage.select_template", templateName);
        }
        if ((dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)prefPageId, (String[])new String[]{prefPageId}, data)).open() == 0) {
            this.updateTemplates();
        }
    }

    protected InputStream getInitialContents() {
        Template template = this.getSelectedTemplate();
        if (this.fUseTemplate && template != null) {
            IFile fileHandle = this.createFileHandle(this.getContainerFullPath().append(this.getResourceName()));
            String lineDelimiter = StubUtility.getLineDelimiterPreference(this.getContainterProject());
            try {
                String content = StubUtility.getFileContent(template, fileHandle, lineDelimiter);
                if (content != null) {
                    try {
                        String charset = fileHandle.getParent().getDefaultCharset();
                        return new ByteArrayInputStream(content.getBytes(charset));
                    }
                    catch (UnsupportedEncodingException exc) {
                        return new ByteArrayInputStream(content.getBytes());
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return super.getInitialContents();
    }

    public void handleEvent(Event event) {
        this.updateTemplates();
        super.handleEvent(event);
    }

    protected void updateTemplates() {
        Template selected = this.getSelectedTemplate();
        boolean isDefaultSelected = selected != null && this.fTemplates.length == 1 || this.fTemplatesCombo != null && this.fTemplatesCombo.getSelectionIndex() == 0;
        this.fTemplates = this.getApplicableTemplates();
        int idx = 0;
        String[] names = new String[this.fTemplates.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.fTemplates[i].getName();
            if (!isDefaultSelected && selected != null && selected.getName().equals(names[i])) {
                idx = i;
            }
            ++i;
        }
        if (this.fTemplatesCombo != null) {
            if (names.length == 0) {
                names = new String[]{NewFileWizardMessages.WizardNewFileFromTemplateCreationPage_noTemplate_name};
            }
            this.fTemplatesCombo.setItems(names);
            this.fTemplatesCombo.select(idx);
        }
    }

    protected Template getSelectedTemplate() {
        if (this.fTemplates != null) {
            int index = 0;
            if (this.fTemplatesCombo != null && (index = this.fTemplatesCombo.getSelectionIndex()) < 0) {
                index = 0;
            }
            if (index < this.fTemplates.length) {
                return this.fTemplates[index];
            }
        }
        return null;
    }

    private String getResourceName() {
        String fileName = this.getFileName();
        String fileExtension = this.getFileExtension();
        if (fileExtension != null && fileExtension.length() > 0 && !fileName.endsWith(String.valueOf('.') + fileExtension)) {
            fileName = String.valueOf(fileName) + '.';
            fileName = String.valueOf(fileName) + fileExtension;
        }
        return fileName;
    }

    private IProject getContainterProject() {
        IPath containerPath = this.getContainerFullPath();
        if (containerPath != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(containerPath.segment(0));
        }
        return null;
    }

    protected Template[] getApplicableTemplates() {
        IProject project = this.getContainterProject();
        String fileName = this.getResourceName();
        String[] contentTypes = WizardNewFileFromTemplateCreationPage.getAllContentTypeIdsForFileName(project, fileName);
        return StubUtility.getFileTemplatesForContentTypes(contentTypes, project);
    }

    private static String[] getAllContentTypeIdsForFileName(IProject project, String fileName) {
        String id;
        IContentType contentType;
        IContentTypeManager matcher;
        if (project == null || !project.isAccessible()) {
            IContentTypeManager contentTypeMgr;
            matcher = contentTypeMgr = Platform.getContentTypeManager();
        } else {
            try {
                matcher = project.getContentTypeMatcher();
            }
            catch (CoreException exc) {
                IContentTypeManager contentTypeMgr;
                matcher = contentTypeMgr = Platform.getContentTypeManager();
            }
        }
        IContentType[] contentTypes = matcher.findContentTypesFor(fileName);
        ArrayList<String> result = new ArrayList<String>(contentTypes.length * 2);
        int i = 0;
        while (i < contentTypes.length) {
            contentType = contentTypes[i];
            id = contentType.getId();
            result.add(id);
            ++i;
        }
        i = 0;
        while (i < contentTypes.length) {
            contentType = contentTypes[i].getBaseType();
            while (contentType != null) {
                id = contentType.getId();
                if (result.contains(id)) break;
                result.add(id);
                contentType = contentType.getBaseType();
            }
            ++i;
        }
        if (result.isEmpty()) {
            result.add("org.eclipse.core.runtime.text");
        }
        return result.toArray(new String[result.size()]);
    }
}

