/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.util.ArrayList;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecore.build.Messages;

public class NativeCoreResourceManager
implements IResourceProxyVisitor {
    private ICSourceEntry[] srcEntries;
    private IProject project;
    private ArrayList<IResource> buildSources;
    private IConfiguration config;
    private static Logger logger = LoggerFactory.getLogger(NativeCoreResourceManager.class);

    public NativeCoreResourceManager(IProject project) {
        this.project = project;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        this.config = info.getDefaultConfiguration();
        this.initialize();
    }

    public NativeCoreResourceManager(IConfiguration config) {
        this.config = config;
        this.project = (IProject)config.getOwner();
        this.initialize();
    }

    private void initialize() {
        this.buildSources = new ArrayList();
        this.srcEntries = this.config.getSourceEntries();
        if (this.srcEntries.length == 0) {
            this.srcEntries = new ICSourceEntry[]{new CSourceEntry((IPath)Path.EMPTY, null, 24)};
        } else {
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)this.config);
            this.srcEntries = CDataUtil.resolveEntries((ICSourceEntry[])this.srcEntries, (ICConfigurationDescription)cfgDes);
        }
        try {
            this.project.accept((IResourceProxyVisitor)this, 0);
        }
        catch (CoreException e) {
            logger.error(NLS.bind((String)Messages.NativeResourceManager_AcceptProjectError, (Object)this.project.getName()), (Throwable)e);
        }
    }

    public boolean visit(IResourceProxy proxy) throws CoreException {
        IResource resource = proxy.requestResource();
        boolean isSource = this.isSource(resource.getProjectRelativePath());
        if (proxy.getType() == 1) {
            IResourceInfo rcInfo = this.config.getResourceInfo(resource.getProjectRelativePath(), false);
            if (isSource) {
                boolean willBuild = false;
                if (rcInfo instanceof IFolderInfo) {
                    String ext = resource.getFileExtension();
                    if (((IFolderInfo)rcInfo).buildsFileType(ext) && !this.isGeneratedResource(resource)) {
                        willBuild = true;
                    }
                } else {
                    willBuild = true;
                }
                if (willBuild) {
                    this.appendBuildResource(resource);
                }
            }
            return false;
        }
        if (proxy.getType() == 2) {
            return isSource && !this.isGeneratedResource(resource);
        }
        return true;
    }

    public boolean isSource(IPath path) {
        return !CDataUtil.isExcluded((IPath)path, (ICSourceEntry[])this.srcEntries);
    }

    public boolean isResourceFile(IPath path) {
        String extention = path.getFileExtension();
        if (extention != null) {
            return extention.equals("edc") || extention.equals("po");
        }
        return false;
    }

    public boolean isGeneratedResource(IResource resource) {
        String[] configNames;
        IPath path = resource.getProjectRelativePath();
        String[] stringArray = configNames = ManagedBuildManager.getBuildInfo((IResource)this.project).getConfigurationNames();
        int n = configNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Path root = new Path(name);
            if (root.isPrefixOf(path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void appendBuildResource(IResource resource) {
        this.buildSources.add(resource);
    }

    public ArrayList<IResource> getBuildSources() {
        return this.buildSources;
    }

    public ArrayList<IPath> getBuildObjectFiles() {
        if (this.config.getBuildArtefactType().getId().equals("org.tizen.buildArtefactType.application")) {
            return this.getBuildObjectFilesOld();
        }
        ArrayList<IPath> result = new ArrayList<IPath>();
        for (IResource resource : this.buildSources) {
            String pathStr = String.valueOf(this.project.getLocation().toString()) + "/" + this.config.getName() + "/" + resource.getProjectRelativePath().removeFileExtension().toString() + ".o";
            result.add((IPath)new Path(pathStr));
        }
        return result;
    }

    private ArrayList<IPath> getBuildObjectFilesOld() {
        ArrayList<IPath> result = new ArrayList<IPath>();
        for (IResource resource : this.buildSources) {
            String pathStr = String.valueOf(this.project.getLocation().toString()) + "/" + this.config.getName() + "/CMakeFiles" + "/" + this.project.getName() + ".dir" + "/" + resource.getProjectRelativePath().toString() + ".o";
            result.add((IPath)new Path(pathStr));
        }
        return result;
    }

    public IPath getDebianRulesFile() {
        return new Path(String.valueOf(this.project.getLocation().toString()) + "/debian/rules");
    }
}

