/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContributedCElement;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final int OVERLAY_ERROR = 8;
    public static final int OVERLAY_WARNING = 16;
    public static final int OVERLAY_OVERRIDE = 32;
    public static final int OVERLAY_IMPLEMENTS = 64;
    public static final int OVERLAY_EXTERNAL = 128;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;

    public CElementImageProvider() {
        ISharedImages images = CUIPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
    }

    public Image getImageLabel(Object element, int flags) {
        Object descriptor = null;
        if (element instanceof ICElement) {
            descriptor = !CCorePlugin.showSourceRootsAtTopOfProject() && element instanceof ICContainer && this.isParentOfSourceRoot(element) ? CDTSharedImages.getImageDescriptor("icons/tobj16/sroot2_obj.png") : this.getCImageDescriptor((ICElement)element, flags);
        } else if (element instanceof IFile) {
            IFile file = (IFile)element;
            String name = file.getName();
            if (CoreModel.isValidTranslationUnitName((IProject)file.getProject(), (String)name) || CoreModel.isValidTranslationUnitName(null, (String)name)) {
                descriptor = CoreModel.isValidCHeaderUnitName(null, (String)name) || CoreModel.isValidCXXHeaderUnitName(null, (String)name) ? CDTSharedImages.getImageDescriptor("icons/tobj16/ch_resource_obj.png") : (CoreModel.isValidASMSourceUnitName(null, (String)name) ? CDTSharedImages.getImageDescriptor("icons/tobj16/asm_resource_obj.png") : CDTSharedImages.getImageDescriptor("icons/tobj16/c_resource_obj.png"));
                Point size = this.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
                descriptor = new CElementImageDescriptor((ImageDescriptor)descriptor, 0, size);
            }
        } else if (!CCorePlugin.showSourceRootsAtTopOfProject() && element instanceof IFolder && this.isParentOfSourceRoot(element)) {
            descriptor = CDTSharedImages.getImageDescriptor("icons/tobj16/sroot2_obj.png");
        }
        if (descriptor == null && element instanceof IAdaptable) {
            descriptor = this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        if (descriptor != null) {
            return CUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isParentOfSourceRoot(Object element) {
        IFolder folder = null;
        if (element instanceof ICContainer && !(element instanceof ISourceRoot)) {
            folder = (IFolder)((ICContainer)element).getResource();
        } else if (element instanceof IFolder) {
            folder = (IFolder)element;
        }
        if (folder == null) {
            return false;
        }
        ICProject cproject = CModelManager.getDefault().getCModel().findCProject(folder.getProject());
        if (cproject == null) return false;
        try {
            IPath folderPath = folder.getFullPath();
            ISourceRoot[] iSourceRootArray = cproject.getSourceRoots();
            int n = iSourceRootArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ISourceRoot sourceRoot = iSourceRootArray[n2];
                IPath sourceRootPath = sourceRoot.getPath();
                if (folderPath.isPrefixOf(sourceRootPath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return false;
    }

    public static ImageDescriptor getImageDescriptor(int type) {
        switch (type) {
            case 30: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/container_obj.png");
            }
            case 14: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/bin_obj.png");
            }
            case 18: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/ar_obj.png");
            }
            case 60: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/c_file_obj.png");
            }
            case 12: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/cfolder_obj.png");
            }
            case 11: {
                return DESC_OBJ_PROJECT;
            }
            case 67: 
            case 85: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/struct_obj.png");
            }
            case 65: 
            case 83: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/class_obj.png");
            }
            case 69: 
            case 87: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/union_obj.png");
            }
            case 80: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/typedef_obj.png");
            }
            case 63: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/enum_obj.png");
            }
            case 81: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/enumerator_obj.png");
            }
            case 72: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/field_public_obj.png");
            }
            case 76: 
            case 92: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/variable_obj.png");
            }
            case 70: 
            case 71: 
            case 90: 
            case 91: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/method_public_obj.png");
            }
            case 74: 
            case 89: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/function_obj.png");
            }
            case 64: 
            case 66: 
            case 68: 
            case 77: 
            case 82: 
            case 84: 
            case 86: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/var_declaration_obj.png");
            }
            case 73: 
            case 88: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/cdeclaration_obj.png");
            }
            case 75: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/include_obj.png");
            }
            case 79: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/define_obj.png");
            }
            case 61: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/namespace_obj.png");
            }
            case 62: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/using_obj.png");
            }
            case 94: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/label_obj.png");
            }
        }
        return null;
    }

    private boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    public ImageDescriptor getCImageDescriptor(ICElement element, int flags) {
        int adornmentFlags = this.computeCAdornmentFlags(element, flags);
        Point size = this.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        ImageDescriptor desc = this.getBaseImageDescriptor(element, flags);
        if (desc != null) {
            return new CElementImageDescriptor(desc, adornmentFlags, size);
        }
        return null;
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        int adornmentFlags = this.computeBasicAdornmentFlags(adaptable, flags);
        Point size = this.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new CElementImageDescriptor(descriptor, adornmentFlags, size);
    }

    public ImageDescriptor getBaseImageDescriptor(ICElement celement, int renderFlags) {
        if (celement instanceof IContributedCElement) {
            return (ImageDescriptor)((IContributedCElement)celement).getAdapter(ImageDescriptor.class);
        }
        int type = celement.getElementType();
        switch (type) {
            case 30: {
                if (celement instanceof IBinaryModule) {
                    return CDTSharedImages.getImageDescriptor("icons/tobj16/bin_obj.png");
                }
                if (celement instanceof ILibraryReference) {
                    return CDTSharedImages.getImageDescriptor("icons/tobj16/unknown_obj.png");
                }
                if (celement instanceof IIncludeReference) {
                    return CDTSharedImages.getImageDescriptor("icons/tobj16/hfolder_obj.png");
                }
                if (celement instanceof IArchiveContainer) {
                    return CDTSharedImages.getImageDescriptor("icons/tobj16/archives_obj.png");
                }
                if (celement instanceof IBinaryContainer) {
                    return CDTSharedImages.getImageDescriptor("icons/tobj16/binaries_obj.png");
                }
                return CDTSharedImages.getImageDescriptor("icons/tobj16/container_obj.png");
            }
            case 14: {
                IBinary bin = (IBinary)celement;
                if (bin.isExecutable()) {
                    if (bin.hasDebug()) {
                        return CDTSharedImages.getImageDescriptor("icons/tobj16/exec_dbg_obj.png");
                    }
                    return CDTSharedImages.getImageDescriptor("icons/tobj16/exec_obj.png");
                }
                if (bin.isSharedLib()) {
                    return CDTSharedImages.getImageDescriptor("icons/tobj16/shlib_obj.png");
                }
                if (bin.isCore()) {
                    return CDTSharedImages.getImageDescriptor("icons/tobj16/core_obj.png");
                }
                return CDTSharedImages.getImageDescriptor("icons/tobj16/bin_obj.png");
            }
            case 18: {
                return CDTSharedImages.getImageDescriptor("icons/tobj16/ar_obj.png");
            }
            case 60: {
                ITranslationUnit unit = (ITranslationUnit)celement;
                if (unit.isHeaderUnit()) {
                    return CDTSharedImages.getImageDescriptor("icons/tobj16/h_file_obj.png");
                }
                if (unit.isSourceUnit() && unit.isASMLanguage()) {
                    return CDTSharedImages.getImageDescriptor("icons/tobj16/s_file_obj.png");
                }
                return CDTSharedImages.getImageDescriptor("icons/tobj16/c_file_obj.png");
            }
            case 12: {
                if (celement instanceof ISourceRoot) {
                    return CDTSharedImages.getImageDescriptor("icons/tobj16/sroot_obj.png");
                }
                return CDTSharedImages.getImageDescriptor("icons/tobj16/cfolder_obj.png");
            }
            case 11: {
                ICProject cp = (ICProject)celement;
                if (cp.getProject().isOpen()) {
                    ImageDescriptor result;
                    IProject project = cp.getProject();
                    IWorkbenchAdapter adapter = (IWorkbenchAdapter)project.getAdapter(IWorkbenchAdapter.class);
                    if (adapter != null && (result = adapter.getImageDescriptor((Object)project)) != null) {
                        return result;
                    }
                    return DESC_OBJ_PROJECT;
                }
                return DESC_OBJ_PROJECT_CLOSED;
            }
            case 67: 
            case 85: {
                return CElementImageProvider.getStructImageDescriptor((renderFlags & 4) != 0);
            }
            case 65: 
            case 83: {
                return CElementImageProvider.getClassImageDescriptor((renderFlags & 4) != 0);
            }
            case 69: 
            case 87: {
                return CElementImageProvider.getUnionImageDescriptor((renderFlags & 4) != 0);
            }
            case 80: {
                return CElementImageProvider.getTypedefImageDescriptor((renderFlags & 4) != 0);
            }
            case 63: {
                return CElementImageProvider.getEnumerationImageDescriptor((renderFlags & 4) != 0);
            }
            case 81: {
                return CElementImageProvider.getEnumeratorImageDescriptor();
            }
            case 72: {
                try {
                    IField field = (IField)celement;
                    ASTAccessVisibility visibility = field.getVisibility();
                    return CElementImageProvider.getFieldImageDescriptor(visibility);
                }
                catch (CModelException e) {
                    return null;
                }
            }
            case 70: 
            case 71: 
            case 90: 
            case 91: {
                try {
                    IMethodDeclaration md = (IMethodDeclaration)celement;
                    ASTAccessVisibility visibility = md.getVisibility();
                    return CElementImageProvider.getMethodImageDescriptor(visibility);
                }
                catch (CModelException e) {
                    return null;
                }
            }
            case 76: 
            case 92: {
                return CElementImageProvider.getVariableImageDescriptor();
            }
            case 74: 
            case 89: {
                return CElementImageProvider.getFunctionImageDescriptor();
            }
            case 64: 
            case 66: 
            case 68: 
            case 77: 
            case 82: 
            case 84: 
            case 86: {
                return CElementImageProvider.getVariableDeclarationImageDescriptor();
            }
            case 73: 
            case 88: {
                return CElementImageProvider.getFunctionDeclarationImageDescriptor();
            }
            case 75: {
                return CElementImageProvider.getIncludeImageDescriptor();
            }
            case 79: {
                return CElementImageProvider.getMacroImageDescriptor();
            }
            case 61: {
                return CElementImageProvider.getNamespaceImageDescriptor();
            }
            case 62: {
                return CElementImageProvider.getUsingImageDescriptor();
            }
        }
        return CElementImageProvider.getImageDescriptor(type);
    }

    private int computeCAdornmentFlags(ICElement element, int renderFlags) {
        int flags = this.computeBasicAdornmentFlags(element, renderFlags);
        if (this.showOverlayIcons(renderFlags)) {
            try {
                if (element instanceof IDeclaration) {
                    IDeclaration decl = (IDeclaration)element;
                    if (decl.isStatic()) {
                        flags |= 8;
                    }
                    if (decl.isConst()) {
                        flags |= 2;
                    }
                    if (decl.isVolatile()) {
                        flags |= 4;
                    }
                    if (element instanceof ITemplate) {
                        flags |= 1;
                    }
                }
                if (element instanceof ISourceReference) {
                    IInclude include;
                    ISourceReference sref = (ISourceReference)element;
                    if (!sref.isActive()) {
                        flags |= 0x8000;
                    } else if (element instanceof IInclude && !(include = (IInclude)element).isResolved()) {
                        flags |= 0x20;
                    }
                }
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
        }
        return flags;
    }

    private int computeBasicAdornmentFlags(Object element, int renderFlags) {
        int flags = 0;
        if ((renderFlags & 8) != 0) {
            flags |= 0x40;
        }
        if ((renderFlags & 0x10) != 0) {
            flags |= 0x20;
        }
        if ((renderFlags & 0x80) != 0) {
            flags |= 0x40000;
        }
        return flags;
    }

    public void dispose() {
    }

    public static ImageDescriptor getStructImageDescriptor() {
        return CElementImageProvider.getStructImageDescriptor(false);
    }

    public static ImageDescriptor getStructImageDescriptor(boolean alt) {
        return alt ? CDTSharedImages.getImageDescriptor("icons/obj16/structfo_obj.gif") : CDTSharedImages.getImageDescriptor("icons/tobj16/struct_obj.png");
    }

    public static ImageDescriptor getClassImageDescriptor() {
        return CElementImageProvider.getClassImageDescriptor(false);
    }

    public static ImageDescriptor getClassImageDescriptor(boolean alt) {
        return alt ? CDTSharedImages.getImageDescriptor("icons/obj16/classfo_obj.gif") : CDTSharedImages.getImageDescriptor("icons/tobj16/class_obj.png");
    }

    public static ImageDescriptor getUnionImageDescriptor() {
        return CElementImageProvider.getUnionImageDescriptor(false);
    }

    public static ImageDescriptor getUnionImageDescriptor(boolean alt) {
        return alt ? CDTSharedImages.getImageDescriptor("icons/obj16/unionfo_obj.gif") : CDTSharedImages.getImageDescriptor("icons/tobj16/union_obj.png");
    }

    public static ImageDescriptor getTypedefImageDescriptor() {
        return CElementImageProvider.getTypedefImageDescriptor(false);
    }

    public static ImageDescriptor getTypedefImageDescriptor(boolean alt) {
        return alt ? CDTSharedImages.getImageDescriptor("icons/obj16/typedeffo_obj.gif") : CDTSharedImages.getImageDescriptor("icons/tobj16/typedef_obj.png");
    }

    public static ImageDescriptor getEnumerationImageDescriptor() {
        return CElementImageProvider.getEnumerationImageDescriptor(false);
    }

    public static ImageDescriptor getEnumerationImageDescriptor(boolean alt) {
        return alt ? CDTSharedImages.getImageDescriptor("icons/obj16/enumfo_obj.gif") : CDTSharedImages.getImageDescriptor("icons/tobj16/enum_obj.png");
    }

    public static ImageDescriptor getEnumeratorImageDescriptor() {
        return CDTSharedImages.getImageDescriptor("icons/tobj16/enumerator_obj.png");
    }

    public static ImageDescriptor getFieldImageDescriptor(ASTAccessVisibility visibility) {
        if (visibility == ASTAccessVisibility.PUBLIC) {
            return CDTSharedImages.getImageDescriptor("icons/tobj16/field_public_obj.png");
        }
        if (visibility == ASTAccessVisibility.PROTECTED) {
            return CDTSharedImages.getImageDescriptor("icons/tobj16/field_protected_obj.png");
        }
        return CDTSharedImages.getImageDescriptor("icons/tobj16/field_private_obj.png");
    }

    public static ImageDescriptor getMethodImageDescriptor(ASTAccessVisibility visibility) {
        if (visibility == ASTAccessVisibility.PUBLIC) {
            return CDTSharedImages.getImageDescriptor("icons/tobj16/method_public_obj.png");
        }
        if (visibility == ASTAccessVisibility.PROTECTED) {
            return CDTSharedImages.getImageDescriptor("icons/tobj16/method_protected_obj.png");
        }
        return CDTSharedImages.getImageDescriptor("icons/tobj16/method_private_obj.png");
    }

    public static ImageDescriptor getVariableImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(76);
    }

    public static ImageDescriptor getLocalVariableImageDescriptor() {
        return CDTSharedImages.getImageDescriptor("icons/tobj16/variable_local_obj.png");
    }

    public static ImageDescriptor getFunctionImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(74);
    }

    public static ImageDescriptor getVariableDeclarationImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(77);
    }

    public static ImageDescriptor getFunctionDeclarationImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(73);
    }

    public static ImageDescriptor getIncludeImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(75);
    }

    public static ImageDescriptor getMacroImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(79);
    }

    public static ImageDescriptor getNamespaceImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(61);
    }

    public static ImageDescriptor getUsingImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(62);
    }

    public static ImageDescriptor getKeywordImageDescriptor() {
        return CDTSharedImages.getImageDescriptor("icons/tobj16/keyword_obj.png");
    }
}

