/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.apihover;

import java.util.ArrayList;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;

public class FunctionSummary
implements IFunctionSummary,
Comparable<FunctionSummary> {
    private String functionName;
    private String namespace;
    private String returnType;
    private String prototype;
    private String description;
    private ArrayList<RequiredInclude> includeFiles = new ArrayList();

    public String getDescription() {
        return this.description;
    }

    public IRequiredInclude[] getIncludes() {
        IRequiredInclude[] includeFilesArray = new IRequiredInclude[this.includeFiles.size()];
        return this.includeFiles.toArray(includeFilesArray);
    }

    public String getName() {
        return this.functionName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public IFunctionSummary.IFunctionPrototypeSummary getPrototype() {
        return new FunctionPrototypeSummary();
    }

    @Override
    public int compareTo(FunctionSummary o) {
        return this.getName().compareTo(o.getName());
    }

    public void setName(String name) {
        this.functionName = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setPrototype(String prototype) {
        this.prototype = prototype;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addIncludeFile(String includeFile) {
        RequiredInclude requiredInclude = new RequiredInclude(includeFile);
        this.includeFiles.add(requiredInclude);
    }

    public class FunctionPrototypeSummary
    implements IFunctionSummary.IFunctionPrototypeSummary {
        public String getArguments() {
            return FunctionSummary.this.prototype;
        }

        public String getName() {
            return FunctionSummary.this.functionName;
        }

        public String getPrototypeString(boolean namefirst) {
            if (namefirst) {
                return String.valueOf(FunctionSummary.this.functionName) + "(" + FunctionSummary.this.prototype + ") " + FunctionSummary.this.returnType;
            }
            return String.valueOf(FunctionSummary.this.returnType) + " " + FunctionSummary.this.functionName + " (" + FunctionSummary.this.prototype + ")";
        }

        public String getReturnType() {
            return FunctionSummary.this.returnType;
        }
    }

    private static class RequiredInclude
    implements IRequiredInclude {
        private String includeFile;

        public RequiredInclude(String includeFile) {
            this.includeFile = includeFile;
        }

        public String getIncludeName() {
            return this.includeFile;
        }

        public boolean isStandard() {
            return true;
        }
    }
}

