/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import java.io.Closeable;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.ISdbCommandHelper;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.TizenNativeException;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.util.IOUtil;

public class TizenLaunchCommand
implements ISdbCommandHelper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int defaultTimeOut = 60000;
    private IDevice currentDevice = null;
    private String commandOutstream = null;
    private String endLine = null;
    private ConsoleManager console = null;
    private boolean showCommand = false;

    public TizenLaunchCommand(IDevice device) {
        this(device, null);
    }

    public TizenLaunchCommand(IDevice device, ConsoleManager console) {
        this.currentDevice = device == null ? ConnectionPlugin.getDefault().getCurrentDevice() : device;
        this.console = console;
    }

    @Deprecated
    public void run(String command) throws CoreException, Exception {
        CommandOuputReceiver receiver = null;
        this.clearBuffer();
        try {
            receiver = new CommandOuputReceiver();
            this.currentDevice.executeShellCommand(command, (IShellOutputReceiver)receiver, 60000);
            this.endLine = receiver.getEndLine();
            this.commandOutstream = receiver.getCommandOutstream();
            if (command.endsWith("; echo cmd_ret:$?;") && !"cmd_ret:0".equals(this.endLine)) {
                throw new TizenNativeException(NLS.bind((String)TizenLaunchMessages.ERROR_COMMAND, (Object)command, (Object)this.commandOutstream));
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(receiver);
            throw throwable;
        }
        IOUtil.tryClose((Closeable)((Object)receiver));
    }

    private void runCommand(String command, String expectedResult, boolean isBlocking) throws CoreException, Exception {
        this.clearBuffer();
        this.logger.debug("$ " + command);
        if (this.isShowCommand() && this.console != null) {
            this.console.println("$ " + command);
        }
        if (isBlocking) {
            this.currentDevice.executeShellCommand(command, false);
            return;
        }
        CommandOuputReceiver receiver = new CommandOuputReceiver();
        try {
            this.currentDevice.executeShellCommand(command, (IShellOutputReceiver)receiver, 60000);
            this.endLine = receiver.getEndLine();
            this.commandOutstream = receiver.getCommandOutstream();
            if (expectedResult != null && !expectedResult.equals(this.endLine)) {
                throw new TizenNativeException(NLS.bind((String)TizenLaunchMessages.ERROR_COMMAND, (Object)command, (Object)this.commandOutstream));
            }
        }
        finally {
            IOUtil.tryClose((Closeable)((Object)receiver));
        }
    }

    public void run(String command, String expectedResult) throws CoreException, Exception {
        this.runCommand(command, expectedResult, false);
    }

    public void run(String command, String expectedResult, boolean isBlocking) throws CoreException, Exception {
        this.runCommand(command, expectedResult, isBlocking);
    }

    public String getCommandOutstream() {
        return this.commandOutstream;
    }

    public String getEndLine() {
        return this.endLine;
    }

    public String[] getResultLineStrings() {
        String strs = this.commandOutstream.toString();
        if (StringUtil.isEmpty((CharSequence)strs)) {
            return (String[])ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        String[] str = StringUtil.split((String)strs, (String)System.getProperty("line.separator"));
        return str;
    }

    private void clearBuffer() {
        this.endLine = null;
        this.commandOutstream = null;
    }

    public void setDevice(IDevice device) {
        this.currentDevice = device;
    }

    public void runCommand(String command, boolean rCode, String expectedResult) throws Exception {
        this.run(command, expectedResult);
    }

    public boolean isShowCommand() {
        return this.showCommand;
    }

    public void setShowCommand(boolean showCommand) {
        this.showCommand = showCommand;
    }

    private final class CommandOuputReceiver
    extends MultiLineReceiver {
        private StringBuilder commandOutstream = new StringBuilder(256);
        private String endLine = null;

        public CommandOuputReceiver() {
            this.setTrimLines(false);
        }

        public void processNewLines(String[] lines) {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (TizenLaunchCommand.this.console != null) {
                    TizenLaunchCommand.this.console.println(line);
                }
                this.commandOutstream.append(line);
                this.commandOutstream.append(File.separatorChar);
                ++n2;
            }
            this.endLine = lines[lines.length - 1];
        }

        public String getCommandOutstream() {
            return this.commandOutstream.toString();
        }

        public String getEndLine() {
            return this.endLine;
        }
    }
}

