/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.ITizenNativeLaunchConfiguration;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.sdblib.IDevice;

public class TizenNativeLaunchConfiguration
implements ITizenNativeLaunchConfiguration,
IAdaptable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ILaunchConfiguration configuration;

    public TizenNativeLaunchConfiguration(ILaunchConfiguration configuration) {
        this.configuration = configuration;
    }

    public IProject getProject() {
        String projectName = null;
        try {
            projectName = this.configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage());
        }
        IProject project = null;
        if (projectName != null) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return project;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IDevice getDeviceFromLaunchConfiguration(IDevice[] devices) {
        String config_device_id = null;
        String device_id = null;
        boolean isEmulator = false;
        try {
            config_device_id = this.configuration.getAttribute("org.tizen.common.launch.device.id", "");
            isEmulator = this.configuration.getAttribute("org.tizen.common.launch.device.emulator", false);
            if (!config_device_id.equals("")) {
                IDevice[] iDeviceArray = devices;
                int n = devices.length;
                int n2 = 0;
                while (n2 < n) {
                    IDevice device = iDeviceArray[n2];
                    if (isEmulator == device.isEmulator() && (device_id = LaunchUtils.getDeviceId(device)).equals(config_device_id)) {
                        return device;
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {
            this.logger.error("Error to get device from launch configuration");
        }
        return null;
    }

    public void setDeviceToLaunchConfiguration(IDevice device) {
        try {
            ILaunchConfigurationWorkingCopy wc = this.configuration.getWorkingCopy();
            boolean isEmulator = true;
            String deviceId = "";
            if (device != null) {
                isEmulator = device.isEmulator();
                deviceId = LaunchUtils.getDeviceId(device);
            }
            wc.setAttribute("org.tizen.common.launch.device.emulator", isEmulator);
            wc.setAttribute("org.tizen.common.launch.device.id", deviceId);
            wc.doSave();
        }
        catch (CoreException coreException) {
            this.logger.error("Error to save configuration working copy");
        }
    }
}

